/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.projectcreate.spi;

import com.google.common.base.Preconditions;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringUtils;

public class AggregateRoot {
    private final String key;
    private final String label;
    private final URI homeUri;

    public AggregateRoot(String key, String label, URI homeUri) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.label = StringUtils.defaultString((String)label);
        this.homeUri = (URI)Preconditions.checkNotNull((Object)homeUri);
    }

    public URI homeUri() {
        return this.homeUri;
    }

    public String key() {
        return this.key;
    }

    public String label() {
        return this.label;
    }

    public static AggregateRoot makeAggregateRoot(String key, String label, String pathPrefix) {
        return new AggregateRoot(key, label, AggregateRoot.makeHomeUri(pathPrefix, key));
    }

    public static URI makeHomeUri(String pathPrefix, String key) {
        try {
            String uri = pathPrefix + URLEncoder.encode(key, "UTF-8");
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new RuntimeException("Unable to create URI for " + uri, e);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Unable to encode URI for /browse/" + key, e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregateRoot that = (AggregateRoot)o;
        return this.key.equals(that.key) && this.label.equals(that.label) && this.homeUri.equals(that.homeUri);
    }

    public int hashCode() {
        return (this.key.hashCode() * 31 + this.label.hashCode()) * 31 + this.homeUri.hashCode();
    }

    public String toString() {
        return String.format("AggregateRoot{key='%s', label='%s', homeUri=%s}", this.key, this.label, this.homeUri.toString());
    }
}

