/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.projectcreate.producer.link;

import com.atlassian.fugue.Either;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLink;
import com.atlassian.plugins.navlink.producer.contentlinks.customcontentlink.CustomContentLinkService;
import com.atlassian.plugins.projectcreate.linking.spi.AggregateRootLinkType;
import com.atlassian.plugins.projectcreate.linking.spi.LocalRoot;
import com.atlassian.plugins.projectcreate.linking.spi.RemoteRoot;
import com.atlassian.plugins.projectcreate.producer.link.util.AggregateRootResourceUrlStore;
import com.atlassian.plugins.projectcreate.producer.link.util.LinkingUrlFactory;
import com.atlassian.plugins.projectcreate.spi.ResponseStatusWithMessage;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.net.URISyntaxException;
import java.util.List;
import javax.annotation.Nullable;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NavLinksRootLinkImpl
implements AggregateRootLinkType {
    private final Logger logger = LoggerFactory.getLogger(NavLinksRootLinkImpl.class);
    private final CustomContentLinkService customContentLinkService;
    private final LinkingUrlFactory linkingUrlFactory;
    private final RequestFactory<?> requestFactory;
    private final AggregateRootResourceUrlStore aggregateRootResourceUrlStore;

    public NavLinksRootLinkImpl(CustomContentLinkService customContentLinkService, LinkingUrlFactory linkingUrlFactory, RequestFactory<?> requestFactory, AggregateRootResourceUrlStore aggregateRootResourceUrlStore) {
        this.customContentLinkService = customContentLinkService;
        this.linkingUrlFactory = linkingUrlFactory;
        this.requestFactory = requestFactory;
        this.aggregateRootResourceUrlStore = aggregateRootResourceUrlStore;
    }

    public boolean canCreateLinkToType(String fromType, String toType) {
        return true;
    }

    public int getWeight() {
        return 256;
    }

    public Either<ResponseStatusWithMessage, Iterable<RemoteRoot>> getRemoteLinkedRootsForLinkedRoot(LocalRoot localRoot) {
        List customContentLinks = this.customContentLinkService.getCustomContentLinks(localRoot.getRootKey());
        Iterable remoteRoots = Iterables.transform((Iterable)customContentLinks, (Function)new Function<CustomContentLink, RemoteRoot>(){

            public RemoteRoot apply(CustomContentLink input) {
                if (input != null && input.getLinkUrl() != null) {
                    try {
                        String aggregateRootUrl = (String)NavLinksRootLinkImpl.this.aggregateRootResourceUrlStore.getAggregateRootUrlForResourceUrl(input.getLinkUrl()).getOrNull();
                        return aggregateRootUrl == null ? null : NavLinksRootLinkImpl.this.linkingUrlFactory.getRemoteRootForUrl(aggregateRootUrl);
                    }
                    catch (URISyntaxException e) {
                        NavLinksRootLinkImpl.this.logger.warn("Custom Content Link contained malformed URL: '" + input.getLinkUrl() + "'", (Throwable)e);
                    }
                }
                return null;
            }
        });
        return Either.right((Object)Iterables.filter((Iterable)remoteRoots, (Predicate)new Predicate<RemoteRoot>(){

            public boolean apply(@Nullable RemoteRoot input) {
                return input != null;
            }
        }));
    }

    public boolean doesLinkExist(LocalRoot localRoot, RemoteRoot theoreticalRemoteRoot) {
        for (RemoteRoot existingRemoteRoot : (Iterable)this.getRemoteLinkedRootsForLinkedRoot(localRoot).right().get()) {
            if (!existingRemoteRoot.equals((Object)theoreticalRemoteRoot)) continue;
            return true;
        }
        return false;
    }

    public Response.Status createLink(final LocalRoot localRoot, final RemoteRoot remoteRoot) {
        if (this.doesLinkExist(localRoot, remoteRoot)) {
            return Response.Status.OK;
        }
        final String remoteRootUrl = this.linkingUrlFactory.getRootUrlForRemote(remoteRoot);
        Request request = this.requestFactory.createRequest(Request.MethodType.GET, remoteRootUrl).addHeader("Accept", "application/json");
        try {
            request.execute(new ResponseHandler(){

                public void handle(Response response) throws ResponseException {
                    try {
                        JSONObject aggregateRoot = new JSONObject(response.getResponseBodyAsString());
                        String resourceUrl = aggregateRoot.getJSONObject("links").getString("resource");
                        NavLinksRootLinkImpl.this.customContentLinkService.addCustomContentLink(CustomContentLink.builder().key(localRoot.getRootKey()).url(resourceUrl).label(aggregateRoot.getString("label")).build());
                        NavLinksRootLinkImpl.this.aggregateRootResourceUrlStore.storeResourceUrlForAggregateRoot(resourceUrl, remoteRootUrl);
                    }
                    catch (JSONException e) {
                        NavLinksRootLinkImpl.this.logger.warn("Could not unmarshall aggregate root response from " + NavLinksRootLinkImpl.this.linkingUrlFactory.getRootUrlForRemote(remoteRoot), (Throwable)e);
                    }
                    catch (Exception e) {
                        NavLinksRootLinkImpl.this.logger.warn("Got exception from customContentLinkService", (Throwable)e);
                    }
                }
            });
        }
        catch (ResponseException e) {
            this.logger.warn("Failed to retrieve aggregate root at " + remoteRootUrl, (Throwable)e);
            return Response.Status.INTERNAL_SERVER_ERROR;
        }
        return Response.Status.ACCEPTED;
    }

    public Response.Status deleteLink(LocalRoot localRoot, final RemoteRoot remoteRoot) {
        Iterable filteredLinks = Iterables.filter((Iterable)this.customContentLinkService.getCustomContentLinks(localRoot.getRootKey()), (Predicate)new Predicate<CustomContentLink>(){

            public boolean apply(CustomContentLink input) {
                return input.getContentKey().equals(remoteRoot.getRootKey());
            }
        });
        for (CustomContentLink filteredLink : filteredLinks) {
            String aggregateRootUrl = (String)this.aggregateRootResourceUrlStore.getAggregateRootUrlForResourceUrl(filteredLink.getLinkUrl()).getOrNull();
            if (!this.linkingUrlFactory.getRootUrlForRemote(remoteRoot).equals(aggregateRootUrl)) continue;
            try {
                this.customContentLinkService.removeCustomContentLink(filteredLink);
                return Response.Status.NO_CONTENT;
            }
            catch (Exception e) {
                this.logger.warn("Got exception when removing content link", (Throwable)e);
                return Response.Status.FORBIDDEN;
            }
        }
        return Response.Status.NOT_FOUND;
    }
}

