/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.BaseFileServerServlet;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.collections.set.ListOrderedSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WebResourceManagerImpl
implements WebResourceManager {
    private Log log = LogFactory.getLog((Class)WebResourceManagerImpl.class);
    private static final String JAVA_SCRIPT_EXTENSION = ".js";
    private static final String CSS_EXTENSION = ".css";
    static final String STATIC_RESOURCE_PREFIX = "s";
    static final String STATIC_RESOURCE_SUFFIX = "_";
    private static final String REQUEST_CACHE_RESOURCE_KEY = "plugin.webresource.names";
    private static final String REQUEST_CACHE_MODE_KEY = "plugin.webresource.mode";
    private static final WebResourceManager.IncludeMode DEFAULT_INCLUDE_MODE = WebResourceManager.DELAYED_INCLUDE_MODE;
    private final WebResourceIntegration webResourceIntegration;

    public WebResourceManagerImpl(WebResourceIntegration webResourceIntegration) {
        this.webResourceIntegration = webResourceIntegration;
    }

    public void requireResource(String resourceName) {
        if (!WebResourceManager.DELAYED_INCLUDE_MODE.equals(this.getIncludeMode())) {
            throw new IllegalStateException("Require Writer for Inline mode.");
        }
        this.requireDelayedResource(resourceName);
    }

    public void requireResource(String resourceName, Writer writer) {
        if (WebResourceManager.DELAYED_INCLUDE_MODE.equals(this.getIncludeMode())) {
            this.requireDelayedResource(resourceName);
        } else {
            try {
                this.includeResource(resourceName, writer);
            }
            catch (IOException e) {
                this.log.error((Object)e);
            }
        }
    }

    private void requireDelayedResource(String resourceName) {
        Map cache = this.webResourceIntegration.getRequestCache();
        Collection webResourceNames = (Collection)cache.get(REQUEST_CACHE_RESOURCE_KEY);
        if (webResourceNames == null) {
            webResourceNames = new ListOrderedSet();
        }
        webResourceNames.add(resourceName);
        cache.put(REQUEST_CACHE_RESOURCE_KEY, webResourceNames);
    }

    public void includeResources(Writer writer) {
        try {
            if (WebResourceManager.DELAYED_INCLUDE_MODE.equals(this.getIncludeMode())) {
                this.includeDelayedResources(writer);
            }
        }
        catch (IOException e) {
            this.log.error((Object)e);
        }
    }

    private void includeDelayedResources(Writer writer) throws IOException {
        Collection webResourceNames = (Collection)this.webResourceIntegration.getRequestCache().get(REQUEST_CACHE_RESOURCE_KEY);
        if (webResourceNames == null || webResourceNames.isEmpty()) {
            return;
        }
        Iterator iterator = webResourceNames.iterator();
        while (iterator.hasNext()) {
            String resourceName = (String)iterator.next();
            this.includeResource(resourceName, writer);
        }
    }

    private void includeResource(String resourceName, Writer writer) throws IOException {
        ModuleDescriptor descriptor = this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(resourceName);
        if (descriptor == null) {
            writer.write("<!-- Error loading resource \"" + resourceName + "\".  Resource not found -->\n");
            return;
        }
        if (!(descriptor instanceof WebResourceModuleDescriptor)) {
            writer.write("<!-- Error loading resource \"" + descriptor + "\". Resource is not a WebResourceModule -->\n");
            return;
        }
        Iterator iterator1 = descriptor.getResourceDescriptors().iterator();
        while (iterator1.hasNext()) {
            ResourceDescriptor resourceDescriptor = (ResourceDescriptor)iterator1.next();
            String name = resourceDescriptor.getName();
            String linkToResource = this.getStaticPluginResourcePrefix(descriptor, resourceDescriptor.getName());
            if (name != null && name.endsWith(JAVA_SCRIPT_EXTENSION)) {
                writer.write("<script type=\"text/javascript\" src=\"" + linkToResource + "\"></script>\n");
                continue;
            }
            if (name != null && name.endsWith(CSS_EXTENSION)) {
                writer.write("<link type=\"text/css\" rel=\"styleSheet\" media=\"all\" href=\"" + linkToResource + "\" />\n");
                continue;
            }
            writer.write("<!-- Error loading resource \"" + descriptor + "\". Type " + resourceDescriptor.getType() + " is not handled -->\n");
        }
    }

    public String getStaticResourcePrefix() {
        return this.webResourceIntegration.getBaseUrl() + "/" + STATIC_RESOURCE_PREFIX + "/" + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + STATIC_RESOURCE_SUFFIX;
    }

    public String getStaticResourcePrefix(String resourceCounter) {
        return this.webResourceIntegration.getBaseUrl() + "/" + STATIC_RESOURCE_PREFIX + "/" + this.webResourceIntegration.getSystemBuildNumber() + "/" + this.webResourceIntegration.getSystemCounter() + "/" + resourceCounter + "/" + STATIC_RESOURCE_SUFFIX;
    }

    public String getStaticPluginResourcePrefix(ModuleDescriptor moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName);
    }

    public String getStaticPluginResource(ModuleDescriptor moduleDescriptor, String resourceName) {
        String prefix = this.getStaticResourcePrefix(moduleDescriptor.getPlugin().getPluginInformation().getVersion());
        String suffix = "/" + BaseFileServerServlet.SERVLET_PATH + "/" + "resources" + "/" + moduleDescriptor.getCompleteKey() + "/" + resourceName;
        return prefix + suffix;
    }

    public String getStaticPluginResource(String pluginModuleKey, String resourceName) {
        return this.getStaticPluginResource(this.webResourceIntegration.getPluginAccessor().getEnabledPluginModule(pluginModuleKey), resourceName);
    }

    public void setIncludeMode(WebResourceManager.IncludeMode includeMode) {
        this.webResourceIntegration.getRequestCache().put(REQUEST_CACHE_MODE_KEY, includeMode);
    }

    WebResourceManager.IncludeMode getIncludeMode() {
        WebResourceManager.IncludeMode includeMode = (WebResourceManager.IncludeMode)this.webResourceIntegration.getRequestCache().get(REQUEST_CACHE_MODE_KEY);
        if (includeMode == null) {
            includeMode = DEFAULT_INCLUDE_MODE;
        }
        return includeMode;
    }
}

