/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.web;

import com.atlassian.plugin.PluginManager;
import com.atlassian.plugin.web.WebFragmentHelper;
import com.atlassian.plugin.web.WebInterfaceManager;
import com.atlassian.plugin.web.descriptors.WebFragmentModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebItemModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WebSectionModuleDescriptor;
import com.atlassian.plugin.web.descriptors.WeightedDescriptorComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultWebInterfaceManager
implements WebInterfaceManager {
    private PluginManager pluginManager;
    private WebFragmentHelper webFragmentHelper;
    private Map sections;
    private Map items;
    private static final Log log = LogFactory.getLog((Class)DefaultWebInterfaceManager.class);
    public static final WeightedDescriptorComparator WEIGHTED_DESCRIPTOR_COMPARATOR = new WeightedDescriptorComparator();

    public DefaultWebInterfaceManager() {
        this.refresh();
    }

    public DefaultWebInterfaceManager(PluginManager pluginManager, WebFragmentHelper webFragmentHelper) {
        this.pluginManager = pluginManager;
        this.webFragmentHelper = webFragmentHelper;
        this.refresh();
    }

    public boolean hasSectionsForLocation(String location) {
        return !this.getSections(location).isEmpty();
    }

    public List getSections(String location) {
        if (location == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WebSectionModuleDescriptor> result = (ArrayList<WebSectionModuleDescriptor>)this.sections.get(location);
        if (result == null) {
            result = new ArrayList<WebSectionModuleDescriptor>();
            List descriptors = this.pluginManager.getEnabledModuleDescriptorsByClass(WebSectionModuleDescriptor.class);
            Iterator iterator = descriptors.iterator();
            while (iterator.hasNext()) {
                WebSectionModuleDescriptor descriptor = (WebSectionModuleDescriptor)iterator.next();
                if (!location.equalsIgnoreCase(descriptor.getLocation())) continue;
                result.add(descriptor);
            }
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            this.sections.put(location, result);
        }
        return result;
    }

    public List getDisplayableSections(String location, Map context) {
        return this.filterFragmentsByCondition(this.getSections(location), context);
    }

    public List getItems(String section) {
        if (section == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<WebItemModuleDescriptor> result = (ArrayList<WebItemModuleDescriptor>)this.items.get(section);
        if (result == null) {
            result = new ArrayList<WebItemModuleDescriptor>();
            List descriptors = this.pluginManager.getEnabledModuleDescriptorsByClass(WebItemModuleDescriptor.class);
            Iterator iterator = descriptors.iterator();
            while (iterator.hasNext()) {
                WebItemModuleDescriptor descriptor = (WebItemModuleDescriptor)iterator.next();
                if (!section.equalsIgnoreCase(descriptor.getSection())) continue;
                result.add(descriptor);
            }
            Collections.sort(result, WEIGHTED_DESCRIPTOR_COMPARATOR);
            this.items.put(section, result);
        }
        return result;
    }

    public List getDisplayableItems(String section, Map context) {
        return this.filterFragmentsByCondition(this.getItems(section), context);
    }

    private List filterFragmentsByCondition(List relevantItems, Map context) {
        if (relevantItems.isEmpty()) {
            return relevantItems;
        }
        ArrayList result = new ArrayList(relevantItems);
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            WebFragmentModuleDescriptor descriptor = (WebFragmentModuleDescriptor)iterator.next();
            try {
                if (descriptor.getCondition() == null || descriptor.getCondition().shouldDisplay(context)) continue;
                iterator.remove();
            }
            catch (Throwable t) {
                log.error((Object)("Could not evaluate condition: " + t));
                iterator.remove();
            }
        }
        return result;
    }

    public void refresh() {
        this.sections = Collections.synchronizedMap(new HashMap());
        this.items = Collections.synchronizedMap(new HashMap());
    }

    public void setPluginManager(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
    }

    public void setWebFragmentHelper(WebFragmentHelper webFragmentHelper) {
        this.webFragmentHelper = webFragmentHelper;
    }

    public WebFragmentHelper getWebFragmentHelper() {
        return this.webFragmentHelper;
    }
}

