/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.servlet.DownloadStrategy;
import com.atlassian.plugin.servlet.PluginResourceDownload;
import com.atlassian.plugin.servlet.ResourceDownloadUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class BaseFileServerServlet
extends HttpServlet {
    public static final String PATH_SEPARATOR = "/";
    public static final String RESOURCE_URL_PREFIX = "resources";
    private static List downloadStrategies = Collections.synchronizedList(new ArrayList());
    private static final Log log = LogFactory.getLog((Class)BaseFileServerServlet.class);
    public static String SERVLET_PATH;

    public void init() throws ServletException {
        super.init();
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public String getMimeType(File fileToServe) {
        return this.getServletContext().getMimeType(fileToServe.getAbsolutePath());
    }

    public void serveFileImpl(HttpServletResponse httpServletResponse, InputStream in) throws IOException {
        ResourceDownloadUtils.serveFileImpl(httpServletResponse, in);
    }

    public abstract String getDecodedPathInfo(HttpServletRequest var1);

    protected abstract DownloadStrategy instantiateDownloadStrategy(Class var1);

    protected abstract String urlDecode(String var1);

    protected abstract String getContentType(String var1);

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            DownloadStrategy downloadStrategy = this.getDownloadStrategy(httpServletRequest);
            if (downloadStrategy != null) {
                downloadStrategy.serveFile(this, httpServletRequest, httpServletResponse);
            } else {
                httpServletResponse.sendError(404, "The file you were looking for was not found");
            }
        }
        catch (Throwable t) {
            log.info((Object)"Error while serving file ", t);
            throw new ServletException(t);
        }
    }

    protected void addDownloadStrategy(Class strategyClass) {
        downloadStrategies.add(strategyClass);
    }

    private DownloadStrategy getDownloadStrategy(HttpServletRequest httpServletRequest) {
        String url = httpServletRequest.getRequestURI().toLowerCase();
        Iterator iterator = downloadStrategies.iterator();
        while (iterator.hasNext()) {
            Class downloadStrategyClass = (Class)iterator.next();
            DownloadStrategy downloadStrategy = this.instantiateDownloadStrategy(downloadStrategyClass);
            if (!downloadStrategy.matches(url)) continue;
            return downloadStrategy;
        }
        return null;
    }

    static {
        downloadStrategies.add(PluginResourceDownload.class);
        SERVLET_PATH = "download";
    }
}

