/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.descriptors;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.Resources;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.loaders.LoaderUtils;
import com.atlassian.plugin.util.JavaVersionUtils;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import org.dom4j.Element;

public abstract class AbstractModuleDescriptor
implements ModuleDescriptor {
    protected Plugin plugin;
    String key;
    String name;
    Class moduleClass;
    String description;
    boolean enabledByDefault = true;
    boolean systemModule = false;
    protected boolean singleton = true;
    Map params;
    protected Resources resources;
    private Float minJavaVersion;
    private String i18nNameKey;
    private String descriptionKey;

    public void init(Plugin plugin, Element element) throws PluginParseException {
        block11: {
            this.plugin = plugin;
            this.key = element.attributeValue("key");
            this.name = element.attributeValue("name");
            this.i18nNameKey = element.attributeValue("i18n-name-key");
            String clazz = element.attributeValue("class");
            try {
                if (clazz == null) break block11;
                this.moduleClass = plugin.loadClass(clazz, this.getClass());
                try {
                    Constructor noargConstructor = this.moduleClass.getConstructor(new Class[0]);
                    if (noargConstructor != null) {
                        this.moduleClass.newInstance();
                    }
                }
                catch (NoSuchMethodException e) {}
            }
            catch (ClassNotFoundException e) {
                throw new PluginParseException("Could not load class: " + clazz, e);
            }
            catch (NoClassDefFoundError e) {
                throw new PluginParseException("Error retrieving dependency of class: " + clazz + ". Missing class: " + e.getMessage());
            }
            catch (UnsupportedClassVersionError e) {
                throw new PluginParseException("Class version is incompatible with current JVM: " + clazz, e);
            }
            catch (Throwable t) {
                throw new PluginParseException(t);
            }
        }
        this.description = element.elementTextTrim("description");
        Element descriptionElement = element.element("description");
        this.descriptionKey = descriptionElement != null ? descriptionElement.attributeValue("key") : null;
        this.params = LoaderUtils.getParams(element);
        if ("disabled".equalsIgnoreCase(element.attributeValue("state"))) {
            this.enabledByDefault = false;
        }
        if ("true".equalsIgnoreCase(element.attributeValue("system"))) {
            this.systemModule = true;
        }
        if (element.element("java-version") != null) {
            this.minJavaVersion = Float.valueOf(element.element("java-version").attributeValue("min"));
        }
        this.singleton = "false".equalsIgnoreCase(element.attributeValue("singleton")) ? false : ("true".equalsIgnoreCase(element.attributeValue("singleton")) ? true : this.isSingletonByDefault());
        this.resources = Resources.fromXml(element);
    }

    public void destroy(Plugin plugin) {
    }

    public boolean isEnabledByDefault() {
        return this.enabledByDefault && this.satisfiesMinJavaVersion();
    }

    public boolean isSystemModule() {
        return this.systemModule;
    }

    public boolean isSingleton() {
        return this.singleton;
    }

    protected boolean isSingletonByDefault() {
        return true;
    }

    protected final void assertModuleClassImplements(Class requiredModuleClazz) throws PluginParseException {
        if (!requiredModuleClazz.isAssignableFrom(this.getModuleClass())) {
            throw new PluginParseException("Given module class: " + this.getModuleClass().getName() + " does not implement " + requiredModuleClazz.getName());
        }
    }

    public String getCompleteKey() {
        return this.plugin.getKey() + ":" + this.getKey();
    }

    public String getPluginKey() {
        return this.plugin.getKey();
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public Class getModuleClass() {
        return this.moduleClass;
    }

    public abstract Object getModule();

    public String getDescription() {
        return this.description;
    }

    public Map getParams() {
        return this.params;
    }

    public String getI18nNameKey() {
        return this.i18nNameKey;
    }

    public String getDescriptionKey() {
        return this.descriptionKey;
    }

    public List getResourceDescriptors() {
        return this.resources.getResourceDescriptors();
    }

    public List getResourceDescriptors(String type) {
        return this.resources.getResourceDescriptors(type);
    }

    public ResourceLocation getResourceLocation(String type, String name) {
        return this.resources.getResourceLocation(type, name);
    }

    public ResourceDescriptor getResourceDescriptor(String type, String name) {
        return this.resources.getResourceDescriptor(type, name);
    }

    public Float getMinJavaVersion() {
        return this.minJavaVersion;
    }

    public boolean satisfiesMinJavaVersion() {
        if (this.minJavaVersion != null) {
            return JavaVersionUtils.satisfiesMinVersion(this.minJavaVersion.floatValue());
        }
        return true;
    }

    public void setPlugin(Plugin plugin) {
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public String toString() {
        return this.getCompleteKey() + " (" + this.getDescription() + ")";
    }
}

