/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.util;

import com.atlassian.webresource.api.assembler.resource.CompleteWebResourceKey;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class WebResourceKeyHelper {
    static final Pattern simpleWebResourceKeyPattern = Pattern.compile("[^:]*:[^:]+");

    public static boolean isWebResourceKey(String key) {
        return key != null && simpleWebResourceKeyPattern.matcher(key).find();
    }

    public static Optional<CompleteWebResourceKey> createWebResourceKey(@Nonnull String completeKey) {
        Objects.requireNonNull(completeKey, "Complete key cannot be null");
        String[] parts = completeKey.split(":");
        boolean isValid = parts.length == 2 && !parts[0].isBlank() && !parts[1].isBlank();
        return isValid ? Optional.of(new CompleteWebResourceKey(parts[0], parts[1])) : Optional.empty();
    }
}

