package com.atlassian.plugin.webresource.impl.snapshot.resource.strategy.contenttype;

import com.atlassian.plugin.elements.ResourceLocation;

import javax.annotation.Nonnull;

import static java.util.Objects.requireNonNull;

public class ContentTypeStrategyFactory {

    public ContentTypeStrategyFactory() {
    }

    public ContentTypeStrategy createDefaultContentTypeStrategy(@Nonnull ResourceLocation resourceLocation) {
        return new DefaultContentTypeStrategy(requireNonNull(resourceLocation));
    }

    public ContentTypeStrategy createModuleContentTypeStrategy(@Nonnull ResourceLocation resourceLocation, @Nonnull String type) {
        return new ModuleContentTypeStrategyDecorator(
                this.createDefaultContentTypeStrategy(resourceLocation),
                requireNonNull(type)
        );
    }
}
