/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.support.http;

import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.http.Router;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class Request {
    private final String path;
    private final Map<String, String> params;
    private final HttpServletRequest originalRequest;
    private final boolean isCacheable;
    private final Globals globals;
    private final String url;

    public Request(Globals globals, String path, Map<String, String> params) {
        this.globals = globals;
        this.originalRequest = null;
        this.params = params;
        this.path = path;
        this.isCacheable = ResourceUtils.canRequestedResourcesContentBeAssumedConstant(this.getParams());
        this.url = Router.buildUrl(path, params);
    }

    public Request(Globals globals, HttpServletRequest request, String encoding) {
        this.globals = globals;
        this.originalRequest = request;
        this.params = ResourceUtils.getQueryParameters(request);
        try {
            this.path = URLDecoder.decode(request.getRequestURI(), encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.isCacheable = ResourceUtils.canRequestedResourcesContentBeAssumedConstant(this.getParams());
        this.url = Router.buildUrl(this.path, this.params);
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public HttpServletRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String getType() {
        return Request.getType(this.path);
    }

    public String getContentType() {
        return this.globals.getConfig().getContentType(this.getPath());
    }

    public static String getType(String path) {
        List<String> parsed = Router.parseWithRe(path, "\\.([^\\.]+)$");
        return parsed.size() > 0 ? parsed.get(0) : null;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isCacheable() {
        return this.isCacheable;
    }

    public Globals getGlobals() {
        return this.globals;
    }
}

