/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.cache.filecache.impl;

import com.atlassian.plugin.cache.filecache.Cache;
import com.atlassian.plugin.cache.filecache.impl.OneStreamCache;
import com.atlassian.plugin.cache.filecache.impl.StreamsCache;
import com.atlassian.plugin.cache.filecache.impl.TwoStreamsCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicLong;

public class FileCacheImpl
implements Cache {
    private static final String ONE_STREAM_KEY_PREFIX = "onestreamkeyprefix:";
    private static final String TWO_STREAMS_KEY_PREFIX = "twostreamskeyprefix:";
    protected static final String EXT = ".cachedfile";
    private final LoadingCache<String, StreamsCache> cache;
    private final File tmpDir;
    private static final AtomicLong filenameCounter = new AtomicLong(0L);

    public FileCacheImpl(File tmpDir, int maxSize) throws IOException {
        if (maxSize < 0) {
            throw new IllegalArgumentException("Max files can not be less than zero");
        }
        FileCacheImpl.initDirectory(tmpDir);
        this.tmpDir = tmpDir;
        this.cache = CacheBuilder.newBuilder().maximumSize((long)maxSize).removalListener((RemovalListener)new RemovalListener<String, StreamsCache>(){

            public void onRemoval(RemovalNotification<String, StreamsCache> notification) {
                FileCacheImpl.this.onEviction((StreamsCache)notification.getValue());
            }
        }).build((CacheLoader)new CacheLoader<String, StreamsCache>(){

            public StreamsCache load(String key) throws Exception {
                return FileCacheImpl.this.newCachedFile(key);
            }
        });
    }

    private static void initDirectory(File tmpDir) throws IOException {
        tmpDir.mkdirs();
        File[] files = tmpDir.listFiles();
        if (files != null) {
            for (File f : files) {
                if (!f.getName().toLowerCase().endsWith(EXT) || f.delete()) continue;
                throw new IOException("Could not delete existing cache file " + f);
            }
        }
        if (!tmpDir.isDirectory()) {
            throw new IOException("Could not create tmp directory " + tmpDir);
        }
    }

    @Override
    public void cache(String bucket, String key, OutputStream out, Cache.StreamProvider provider) {
        StreamsCache cachedFile = (StreamsCache)this.cache.getUnchecked((Object)(ONE_STREAM_KEY_PREFIX + bucket + ":" + key));
        cachedFile.stream(out, provider);
    }

    @Override
    public void cacheTwo(String bucket, String key, OutputStream out1, OutputStream out2, Cache.TwoStreamProvider provider) {
        StreamsCache cachedFile = (StreamsCache)this.cache.getUnchecked((Object)(TWO_STREAMS_KEY_PREFIX + bucket + ":" + key));
        cachedFile.streamTwo(FileCacheImpl.ensureNotNull(out1), FileCacheImpl.ensureNotNull(out2), provider);
    }

    @Override
    public void clear() {
        ArrayList cachedFiles = new ArrayList(this.cache.asMap().values());
        this.cache.invalidateAll();
        for (StreamsCache cachedFile : cachedFiles) {
            cachedFile.deleteWhenPossible();
        }
    }

    private StreamsCache newCachedFile(String key) {
        if (key.startsWith(ONE_STREAM_KEY_PREFIX)) {
            File file = new File(this.tmpDir, this.generateNextFileName());
            return new OneStreamCache(file);
        }
        if (key.startsWith(TWO_STREAMS_KEY_PREFIX)) {
            File file1 = new File(this.tmpDir, this.generateNextFileName());
            File file2 = new File(this.tmpDir, this.generateNextFileName());
            return new TwoStreamsCache(file1, file2);
        }
        throw new RuntimeException("internal error, invalid cache key '" + key + "' prefix!");
    }

    private void onEviction(StreamsCache node) {
        node.deleteWhenPossible();
    }

    public static OutputStream ensureNotNull(OutputStream stream) {
        return stream != null ? stream : new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }
        };
    }

    protected String generateNextFileName() {
        return filenameCounter.incrementAndGet() + EXT;
    }
}

