package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.cdn.CdnResourceUrlTransformer;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.url.UrlBuilder;

/**
 * {@link com.atlassian.plugin.webresource.transformer.StaticTransformers} implementation.
 *
 * @since v3.1.0
 */
public class DefaultStaticTransformers implements StaticTransformers
{
    private final StaticTransformersSupplier staticTransformersSupplier;

    public DefaultStaticTransformers(StaticTransformersSupplier staticTransformersSupplier)
    {
        this.staticTransformersSupplier = staticTransformersSupplier;
    }

    @Override
    public void addToUrl(String locationType, TransformerParameters transformerParameters, UrlBuilder urlBuilder, UrlBuildingStrategy urlBuildingStrategy)
    {
        for (ContentTransformerFactory transformerFactory : transformersForType(locationType))
        {
            urlBuildingStrategy.addToUrl(transformerFactory.makeUrlBuilder(transformerParameters), urlBuilder);
        }
    }

    @Override
    public Content transform(CdnResourceUrlTransformer cdnResourceUrlTransformer, Content content, TransformerParameters transformerParameters,
            ResourceLocation resourceLocation, QueryParams queryParams, String sourceUrl)
    {
        for (ContentTransformerFactory transformerFactory : transformersForLocation(resourceLocation))
        {
            content = transformerFactory.makeResourceTransformer(transformerParameters).transform(
                    cdnResourceUrlTransformer, content, resourceLocation, queryParams, sourceUrl);
        }
        return content;
    }

    private Iterable<ContentTransformerFactory> transformersForType(final String locationType)
    {
        return staticTransformersSupplier.get(locationType);
    }

    private Iterable<ContentTransformerFactory> transformersForLocation(final ResourceLocation location)
    {
        return staticTransformersSupplier.get(location);
    }
}
