package com.atlassian.plugin.webresource.impl.snapshot;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.ContentImpl;
import com.atlassian.sourcemap.SourceMap;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;


/**
 * Virtual resource for Context, needed to add `require` statement for modules.
 *
 * @since v3.4.4
 */
public class ContextResource extends Resource
{
    private final List<String> moduleDependencies;

    public ContextResource(Bundle parent, List<String> moduleDependencies)
    {
        super(parent, new ResourceLocation("context-virtual-resource.js", "context-virtual-resource.js", "js", "js", null, new HashMap<>()), "js", "js");
        this.moduleDependencies = moduleDependencies;
    }

    @Override
    public Content getContent()
    {
        return new ContentImpl(getContentType(), false)
        {
            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled)
            {
                // Requiring module dependencies.
                if (moduleDependencies.size() > 0)
                {
                    try
                    {
                        out.write("require([".getBytes());
                        for (int i = 0; i < moduleDependencies.size(); i++)
                        {
                            if (i != 0) {
                                out.write(", ".getBytes());
                            }
                            out.write(("\"" + moduleDependencies.get(i) + "\"").getBytes());
                        }
                        out.write("]);\n".getBytes());
                    }
                    catch (IOException e)
                    {
                        throw new RuntimeException(e);
                    }
                }
                return null;
            }
        };
    }

    @Override
    public boolean isTransformable()
    {
        return false;
    }
}
