package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.impl.CachedCondition;
import com.atlassian.plugin.webresource.impl.CachedTransformers;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.impl.snapshot.Snapshot;
import com.atlassian.webresource.api.prebake.Dimensions;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;

/**
 * Default implementation of WebResourceAssemblerFactory
 * @since v3.0
 */
public class DefaultWebResourceAssemblerFactory implements PrebakeWebResourceAssemblerFactory
{
    private final Globals globals;

    public DefaultWebResourceAssemblerFactory(Globals globals)
    {
        this.globals = globals;
    }

    public DefaultWebResourceAssemblerFactory(
        ResourceBatchingConfiguration batchingConfiguration,
        WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider,
        PluginResourceLocator pluginResourceLocator, StaticTransformers staticTransformers)
    {
        this(pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt());
    }

    @Override
    public PrebakeWebResourceAssemblerBuilder create()
    {
        return new DefaultWebResourceAssemblerBuilder(globals);
    }

    @Override
    public Dimensions computeDimensions()
    {
        Snapshot snapshot = globals.getSnapshot();
        Dimensions d = Dimensions.empty();
        for (CachedCondition condition : snapshot.conditions())
        {
            d = d.product(condition.computeDimensions());
        }
        for (CachedTransformers transformer : snapshot.transformers())
        {
            d = d.product(transformer.computeDimensions(globals.getConfig().getTransformerCache()));
        }
        return d;
    }

    @Override
    public String computeGlobalStateHash()
    {
        return globals.getConfig().computeGlobalStateHash();
    }

    /**
     * @deprecated since 3.3.2
     */
    @Override
    @Deprecated
    public void clearCache()
    {
        globals.triggerStateChange();
    }
}
