/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.support;

import com.atlassian.plugin.webresource.impl.snapshot.Bundle;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.sourcemap.Mapping;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.SourceMapImpl;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Support {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"webresource");

    public static Predicate<Bundle> efficientAndPredicate(List<Predicate<Bundle>> predicates) {
        if (predicates.size() == 0) {
            return Predicates.alwaysTrue();
        }
        if (predicates.size() == 1) {
            return predicates.get(0);
        }
        return Predicates.and(predicates);
    }

    public static String indent(String string, String indent) {
        return indent + string.replaceAll("\\n", "\n" + indent);
    }

    public static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    public static void copy(InputStream in, OutputStream out) {
        try {
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
            try {
                out.flush();
            }
            catch (IOException e) {
                LOGGER.debug("Error flushing output stream", (Throwable)e);
            }
        }
    }

    public static Element parseXml(String xml) {
        Document document;
        try {
            document = DocumentHelper.parseText((String)xml);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
        return document.getRootElement();
    }

    public static SourceMap replaceSourceUrl(SourceMap sourceMap, String sourceUrl) {
        SourceMapImpl result = new SourceMapImpl();
        sourceMap.eachMapping(new SourceMap.EachMappingCallback((SourceMap)result, sourceUrl){
            final /* synthetic */ SourceMap val$result;
            final /* synthetic */ String val$sourceUrl;
            {
                this.val$result = sourceMap;
                this.val$sourceUrl = string;
            }

            public void apply(Mapping mapping) {
                this.val$result.addMapping(mapping.getGeneratedLine(), mapping.getGeneratedColumn(), mapping.getSourceLine(), mapping.getSourceColumn(), this.val$sourceUrl, mapping.getSourceSymbolName());
            }
        });
        return result;
    }

    public static SourceMap getSourceMap(String resourcePath, Resource resource, String sourceUrl) {
        String pathForSourceMap = resourcePath + ".map";
        InputStream sourceMapAsStream = resource.getStreamFor(pathForSourceMap);
        if (sourceMapAsStream == null) {
            return null;
        }
        SourceMapImpl sourceMap = new SourceMapImpl(sourceMapAsStream);
        return Support.replaceSourceUrl((SourceMap)sourceMap, sourceUrl);
    }
}

