package com.atlassian.plugin.webresource.impl.snapshot;

/**
 * Container for a root-page. This class wraps a normal {@link WebResource}, and adds an additional flag that
 * specifies the superbatch inclusion behaviour.
 *
 * @since 3.5.9
 */
public final class RootPage {

    private final WebResource webResource;
    private final boolean superbatchIncluded;

    public RootPage(
            WebResource webResource,
            boolean superbatchIncluded) {
        this.webResource = webResource;
        this.superbatchIncluded = superbatchIncluded;
    }

    public WebResource getWebResource() {
        return webResource;
    }

    public boolean isSuperbatchIncluded() {
        return superbatchIncluded;
    }

}
