/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import com.atlassian.plugin.webresource.impl.support.Content;
import com.atlassian.plugin.webresource.impl.support.ContentImpl;
import com.atlassian.plugin.webresource.impl.support.Support;
import com.atlassian.sourcemap.Mapping;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.SourceMapImpl;
import com.atlassian.webresource.spi.CompilerUtil;
import com.atlassian.webresource.spi.ResourceCompiler;
import java.io.InputStream;
import java.io.OutputStream;

public class MinificationTransformer {
    public static Content minify(final Config config, final Resource resource, final Content content, final String sourceUrl) {
        if (MinificationTransformer.isMinificationEnabledFor(config, resource)) {
            return new ContentImpl(content.getContentType(), true){

                @Override
                public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                    String pathForMinifiedVersion = MinificationTransformer.getPathForMinifiedVersion(resource.getPath());
                    InputStream minifiedStream = null;
                    if (config.isGlobalMinificationEnabled() && resource.getNameOrLocationType().equals("js")) {
                        minifiedStream = CompilerUtil.toInputStream((ResourceCompiler)config.getResourceCompiler(), (String)resource.getPath());
                    }
                    if (minifiedStream == null) {
                        minifiedStream = resource.getStreamFor(pathForMinifiedVersion);
                    }
                    if (minifiedStream == null) {
                        pathForMinifiedVersion = MinificationTransformer.getAlternatePathForMinifiedVersion(resource.getPath());
                        minifiedStream = resource.getStreamFor(pathForMinifiedVersion);
                    }
                    if (minifiedStream == null) {
                        content.writeTo(out, isSourceMapEnabled);
                        return null;
                    }
                    Support.copy(minifiedStream, out);
                    if (isSourceMapEnabled) {
                        String pathForSourceMap = pathForMinifiedVersion + ".map";
                        InputStream sourceMapAsStream = resource.getStreamFor(pathForSourceMap);
                        if (sourceMapAsStream == null) {
                            return null;
                        }
                        try {
                            SourceMapImpl sourceMap = new SourceMapImpl(sourceMapAsStream);
                            return MinificationTransformer.replaceSourceUrl((SourceMap)sourceMap, sourceUrl);
                        }
                        catch (RuntimeException e) {
                            Support.LOGGER.warn("can't parse source map for " + resource.getKey() + "/" + resource.getName(), (Throwable)e);
                            return null;
                        }
                    }
                    return null;
                }
            };
        }
        return content;
    }

    private static SourceMap replaceSourceUrl(SourceMap sourceMap, String sourceUrl) {
        SourceMapImpl result = new SourceMapImpl();
        sourceMap.eachMapping(new SourceMap.EachMappingCallback((SourceMap)result, sourceUrl){
            final /* synthetic */ SourceMap val$result;
            final /* synthetic */ String val$sourceUrl;
            {
                this.val$result = sourceMap;
                this.val$sourceUrl = string;
            }

            public void apply(Mapping mapping) {
                this.val$result.addMapping(mapping.getGeneratedLine(), mapping.getGeneratedColumn(), mapping.getSourceLine(), mapping.getSourceColumn(), this.val$sourceUrl);
            }
        });
        return result;
    }

    private static boolean isMinificationEnabledFor(Config config, Resource resource) {
        if (!resource.getParent().isMinificationEnabled()) {
            return false;
        }
        if (!config.isMinificationEnabled()) {
            return false;
        }
        String path = resource.getPath();
        if (path.endsWith(".js")) {
            return !path.endsWith("-min.js") && !path.endsWith(".min.js");
        }
        if (path.endsWith(".css")) {
            return !path.endsWith("-min.css") && !path.endsWith(".min.css");
        }
        return false;
    }

    private static String getPathForMinifiedVersion(String path) {
        int lastDot = path.lastIndexOf(".");
        return path.substring(0, lastDot) + "-min" + path.substring(lastDot);
    }

    private static String getAlternatePathForMinifiedVersion(String path) {
        int lastDot = path.lastIndexOf(".");
        return path.substring(0, lastDot) + ".min" + path.substring(lastDot);
    }
}

