/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.impl.annotators;

import com.atlassian.plugin.webresource.impl.annotators.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.impl.snapshot.Resource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedHashSet;
import java.util.List;

public class ListOfAnnotators
extends ResourceContentAnnotator {
    private final List<ResourceContentAnnotator> annotators;

    public ListOfAnnotators(List<ResourceContentAnnotator> annotators) {
        this.annotators = annotators;
    }

    @Override
    public int beforeResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException {
        int offset = 0;
        for (ResourceContentAnnotator annotator : this.annotators) {
            offset += annotator.beforeResourceInBatch(requiredResources, resource, stream);
        }
        return offset;
    }

    @Override
    public void afterResourceInBatch(LinkedHashSet<String> requiredResources, Resource resource, OutputStream stream) throws IOException {
        for (int i = this.annotators.size() - 1; i >= 0; --i) {
            this.annotators.get(i).afterResourceInBatch(requiredResources, resource, stream);
        }
    }

    @Override
    public int beforeAllResourcesInBatch(LinkedHashSet<String> requiredResources, String url, OutputStream stream) throws IOException {
        int offset = 0;
        for (ResourceContentAnnotator annotator : this.annotators) {
            offset += annotator.beforeAllResourcesInBatch(requiredResources, url, stream);
        }
        return offset;
    }

    @Override
    public void afterAllResourcesInBatch(LinkedHashSet<String> requiredResources, String url, OutputStream stream) throws IOException {
        for (int i = this.annotators.size() - 1; i >= 0; --i) {
            this.annotators.get(i).afterAllResourcesInBatch(requiredResources, url, stream);
        }
    }

    @Override
    public int beforeResource(LinkedHashSet<String> requiredResources, String url, Resource resource, OutputStream stream) throws IOException {
        int offset = 0;
        for (ResourceContentAnnotator annotator : this.annotators) {
            offset += annotator.beforeResource(requiredResources, url, resource, stream);
        }
        return offset;
    }

    @Override
    public void afterResource(LinkedHashSet<String> requiredResources, String url, Resource resource, OutputStream stream) throws IOException {
        for (int i = this.annotators.size() - 1; i >= 0; --i) {
            this.annotators.get(i).afterResource(requiredResources, url, resource, stream);
        }
    }

    @Override
    public int hashCode() {
        return this.annotators.hashCode();
    }
}

