/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssembler;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.RequestState;
import com.atlassian.plugin.webresource.impl.UrlBuildingStrategy;
import com.atlassian.plugin.webresource.impl.snapshot.RootPage;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssembler;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerBuilder;
import com.atlassian.plugin.webresource.util.TimeSpan;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerBuilder;
import com.atlassian.webresource.api.prebake.Coordinate;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public class DefaultWebResourceAssemblerBuilder
implements PrebakeWebResourceAssemblerBuilder {
    private final Globals globals;
    private Optional<Boolean> isSuperBatchingEnabled = Optional.empty();
    private Optional<RootPage> rootPage = Optional.empty();
    private Optional<TimeSpan> deadline = Optional.empty();
    private Optional<Coordinate> coord = Optional.empty();

    public DefaultWebResourceAssemblerBuilder(Globals globals) {
        this.globals = globals;
    }

    @Override
    public PrebakeWebResourceAssemblerBuilder withCoordinate(Coordinate coord) {
        this.coord = Optional.of(coord);
        return this;
    }

    @Override
    public PrebakeWebResourceAssembler build() {
        boolean includeSuperbatch = this.globals.getConfig().isSuperBatchingEnabled();
        UrlBuildingStrategy urlStrat = UrlBuildingStrategy.from(this.coord);
        RequestState requestState = new RequestState(this.globals, urlStrat);
        if (this.deadline.isPresent()) {
            requestState.setBigPipeDeadline(System.currentTimeMillis() + this.deadline.get().toMillis());
        }
        if (this.rootPage.isPresent()) {
            RootPage rp = this.rootPage.get();
            requestState.getIncluded().addAll(rp.getWebResource().getDependencies());
            includeSuperbatch = rp.isSuperbatchIncluded();
        }
        if (this.isSuperBatchingEnabled.isPresent()) {
            includeSuperbatch = this.isSuperBatchingEnabled.get();
        }
        DefaultWebResourceAssembler assembler = new DefaultWebResourceAssembler(requestState, this.globals.getConfig());
        if (includeSuperbatch) {
            assembler.resources().requireContext("_super");
        }
        return assembler;
    }

    public WebResourceAssemblerBuilder includeSuperbatchResources(boolean include) {
        this.isSuperBatchingEnabled = Optional.of(include);
        return this;
    }

    public WebResourceAssemblerBuilder includePage(String rootPage) {
        this.rootPage = Optional.of(this.globals.getSnapshot().getRootPage(rootPage));
        return this;
    }

    public WebResourceAssemblerBuilder asyncDataDeadline(long deadline, TimeUnit timeunit) {
        this.deadline = Optional.of(new TimeSpan(deadline, timeunit));
        return this;
    }
}

