/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.AbstractWebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;

public class CssWebResource
extends AbstractWebResourceFormatter {
    public static final WebResourceFormatter FORMATTER = new CssWebResource();
    private static final String CSS_EXTENSION = ".css";
    private static final String MEDIA_PARAM = "media";
    private static final String IEONLY_PARAM = "ieonly";
    private static final String CONDITION_PARAM = "conditionalComment";
    private static final List<String> HANDLED_PARAMETERS = Arrays.asList("title", "media", "charset");

    @Override
    public boolean matches(String name) {
        return name != null && name.endsWith(CSS_EXTENSION);
    }

    @Override
    public String formatResource(String url, Map<String, String> attributes) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"");
        buffer.append(StringEscapeUtils.escapeHtml((String)url)).append("\"");
        List<String> attributeTokens = this.getParametersAsAttributes(attributes);
        if (attributes != null && attributes.size() > 0) {
            buffer.append(" ").append(StringUtils.join(attributeTokens.iterator(), (String)" "));
        }
        if (!attributes.containsKey(MEDIA_PARAM)) {
            buffer.append(" media=\"all\"");
        }
        buffer.append(">\n");
        if (attributes.containsKey(CONDITION_PARAM)) {
            String condition = attributes.get(CONDITION_PARAM);
            buffer.insert(0, "<!--[if " + condition + "]>\n");
            buffer.append("<![endif]-->\n");
        } else if (BooleanUtils.toBoolean((String)attributes.get(IEONLY_PARAM))) {
            buffer.insert(0, "<!--[if IE]>\n");
            buffer.append("<![endif]-->\n");
        }
        return buffer.toString();
    }

    @Override
    protected List<String> getAttributeParameters() {
        return HANDLED_PARAMETERS;
    }
}

