package com.atlassian.plugin.webresource.bigpipe;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Typed key
 * @since 3.3
 */
public final class Key implements Comparable<Key>
{
    private final String key;

    public static Key of(String key)
    {
        return new Key(key);
    }

    public Key(String key)
    {
        this.key = checkNotNull(key);
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        return key.equals(((Key) o).key);
    }

    @Override
    public int hashCode()
    {
        return key.hashCode();
    }

    @Override
    public String toString()
    {
        return key;
    }

    @Override
    public int compareTo(Key o)
    {
        return key.compareTo(o.key);
    }
}
