package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;

import java.util.Date;
import java.util.List;

/**
 * WARNING Do not use it, it will be removed in the next version!
 *
 * Virtual Web Resource, to represent Context or Super Batch.
 *
 * @since 3.3
 */
@Internal
public class WebResource extends Bundle
{
    public WebResource(Config.Snapshot snapshot, String key, List<String> dependencies, Date updatedAt,
            String version, boolean isTransformable)
    {
        super(snapshot, key, dependencies, updatedAt, version, isTransformable);
    }

    /**
     * Get Condition for this Web Resource, can be null.
     */
    public DecoratingCondition getCondition()
    {
        return snapshot.webResourcesCondition.get(this);
    }

    /**
     * Get list of Transformatiosn for this Web Resource, can be null.
     */
    public List<WebResourceTransformation> getTransformations()
    {
        return snapshot.webResourcesTransformations.get(this);
    }

    // Instead of storing plugin and web resource kyes and taking memory, evaluating it each time it is used,
    // it used during
    // transformation only.
    @Deprecated
    public String getWebResourceKey()
    {
        return getKey().split(":")[1];
    }

    @Deprecated
    public String getPluginKey()
    {
        return getKey().split(":")[0];
    }
}