package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.elements.ResourceLocation;
import com.google.common.base.Objects;

import java.util.Date;
import java.util.Map;

import static com.atlassian.plugin.webresource.PluginResourceLocator.BATCH_PARAMS;

/**
 * WARNING Do not use it, it will be removed in the next version!
 *
 * Resource of Web Resource or Plugin.
 *
 * @since 3.3
 */
@Internal
public class Resource
{
    private final Bundle parent;
    private final String type;
    private final boolean isBatchable;
    private final ResourceLocation resourceLocation;
    private final boolean isRedirect;
    private final boolean isCacheable;

    protected Resource(Bundle parent, ResourceLocation resourceLocation, String type, boolean isBatchable,
            boolean isRedirect, boolean isCacheable)
    {
        this.parent = parent;
        this.type = type;
        this.isBatchable = isBatchable;
        this.isRedirect = isRedirect;
        this.isCacheable = isCacheable;
        this.resourceLocation = resourceLocation;
    }

    /**
     * Get Parent - Web Resource or Plugin.
     */
    public Bundle getParent()
    {
        return parent;
    }

    public String getName()
    {
        return resourceLocation.getName();
    }

    public String getLocation()
    {
        return resourceLocation.getLocation();
    }

    public boolean isRedirect()
    {
        return isRedirect;
    }

    public String getType()
    {
        return type;
    }

    public String getContentType()
    {
        return resourceLocation.getContentType();
    }

    public boolean isBatchable()
    {
        return isBatchable;
    }

    /**
     * Should it be included in Batch with given Parameters?
     */
    public boolean isBatchable(Map<String, String> batchParams)
    {
        if (!isBatchable || isRedirect())
        {
            return false;
        }
        for (final String key : BATCH_PARAMS)
        {
            if (!Helpers.equals(batchParams.get(key), getParams().get(key)))
            {
                return false;
            }
        }
        return true;
    }

    public Map<String, String> getParams()
    {
        return resourceLocation.getParams();
    }

    public Date getUpdatedAt()
    {
        return parent.getUpdatedAt();
    }

    public boolean isTransformable()
    {
        return parent.isTransformable();
    }

    public String getVersion()
    {
        return parent.getVersion();
    }

    public String getKey()
    {
        return parent.getKey();
    }

    public boolean isCacheable()
    {
        return isCacheable;
    }

    public boolean isCdnSupported()
    {
        return parent.isCdnSupported();
    }

    public Content getContent()
    {
        return parent.getSnapshot().config.getContentFor(this);
    }

    @Deprecated
    public ResourceLocation getResourceLocation()
    {
        return resourceLocation;
    }

    @Override
    public boolean equals(Object o)
    {
        if (this == o)
        {
            return true;
        }
        if ((o == null) || (getClass() != o.getClass()))
        {
            return false;
        }
        Resource resource = (Resource) o;
        return parent.equals(resource.parent) && getName().equals(resource.getName());
    }

    @Override
    public int hashCode()
    {
        return Objects.hashCode(parent, getName());
    }

    @Override
    public String toString()
    {
        return "{" + getName() + (!isBatchable() ? " isNotBatchable" : "") + "}";
    }

    // There's a method `getFilePath` on the resource but no the `filePath` variable itself,
    // this is done in order to not take
    // additional memory. The case when the `filePath` is different from the empty string is rare,
    // and handled by overriding this
    // method.
    @Deprecated
    public String getFilePath()
    {
        return "";
    }
}