package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.url.UrlParameters;
import com.atlassian.plugin.webresource.util.HashBuilder;
import com.google.common.collect.ImmutableMap;

import java.util.Map;
import java.util.Set;

/**
 * Abstract base class for plugin resources
 *
 * @since v3.0
 */
public abstract class AbstractPluginResource implements PluginResource
{
    protected final UrlParameters urlParams;
    protected final Map<String, String> params;
    protected final Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors;
    protected final Globals globals;

    protected AbstractPluginResource(Globals globals, UrlParameters urlParams, Map<String, String> params,
            Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors)
    {
        this.globals = globals;
        this.urlParams = urlParams;
        this.params = ImmutableMap.copyOf(params);
        this.batchedWebResourceDescriptors = batchedWebResourceDescriptors;
    }

    @Override
    public UrlParameters getUrlParameters()
    {
        return urlParams;
    }

    /**
     * @return a map of parameter key and value pairs for this resource, can be empty but never null. Resources that
     * have any values in this map will be included in a separate batch.
     */
    public Map<String, String> getParams()
    {
        return params;
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors()
    {
        return batchedWebResourceDescriptors;
    }

    public String getUrl()
    {
        return getUrl(false);
    }

    public String getHash()
    {
        return HashBuilder.buildHash(urlParams.allHashes());
    }

    public boolean isCdnSupported()
    {
        return getUrlParameters().isCdnSupported();
    }
}
