/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.Bundle;
import com.atlassian.plugin.webresource.Content;
import com.atlassian.plugin.webresource.ContentImpl;
import com.atlassian.plugin.webresource.Globals;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.RequestCache;
import com.atlassian.plugin.webresource.Resource;
import com.atlassian.plugin.webresource.ResourceContentAnnotator;
import com.atlassian.plugin.webresource.WebResource;
import com.atlassian.plugin.webresource.WebResourceTransformation;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.support.LineCountingProxyOutputStream;
import com.atlassian.plugin.webresource.support.SourceMapJoinerStub;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.sourcemap.SourceMap;
import com.atlassian.sourcemap.SourceMapJoiner;
import com.atlassian.sourcemap.Util;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Internal
public class Helpers {
    public static boolean isConditionSatisfied(Bundle bundle, Map<String, String> httpParams) {
        if (bundle instanceof WebResource) {
            DecoratingCondition condition = ((WebResource)bundle).getCondition();
            return condition == null || condition.shouldDisplay(QueryParams.of(httpParams));
        }
        return true;
    }

    public static Predicate<Bundle> isConditionSatisfiedPredicate(final Map<String, String> httpParams) {
        return new Predicate<Bundle>(){

            public boolean apply(Bundle bundle) {
                return Helpers.isConditionSatisfied(bundle, httpParams);
            }
        };
    }

    public static Resource getResource(Globals globals, RequestCache cache, String completeKey, String resourceName) {
        Resource resource = Helpers.getWebResourceResource(globals, cache, completeKey, resourceName);
        if (resource == null) {
            resource = Helpers.getModuleResource(globals, completeKey, resourceName);
        }
        if (resource == null) {
            resource = Helpers.getResourceRelativeToWebResource(globals, cache, completeKey, resourceName);
        }
        if (resource == null) {
            resource = Helpers.getPluginResource(globals, completeKey, resourceName);
        }
        if (resource == null) {
            resource = Helpers.getResourceRelativeToPlugin(globals, completeKey, resourceName);
        }
        return resource;
    }

    public static Collection<Resource> getResources(Globals globals, RequestCache cache, Collection<String> keys) {
        LinkedList<Resource> resources = new LinkedList<Resource>();
        for (String key : keys) {
            Bundle bundle = globals.getBundles().get(key);
            if (bundle == null) continue;
            for (Resource resource : bundle.getResources(cache).values()) {
                resources.add(resource);
            }
        }
        return resources;
    }

    public static Resource getModuleResource(Globals globals, String completeKeyOrPluginKey, String resourceName) {
        return globals.getConfig().getModuleResource(completeKeyOrPluginKey, resourceName);
    }

    public static Resource getPluginResource(Globals globals, String completeKeyOrPluginKey, String resourceName) {
        return globals.getConfig().getPluginResource(Helpers.getPluginKey(completeKeyOrPluginKey), resourceName);
    }

    public static Resource getWebResourceResource(Globals globals, RequestCache cache, String completeKey, String resourceName) {
        Bundle bundle = globals.getBundles().get(completeKey);
        if (bundle == null) {
            return null;
        }
        return bundle.getResources(cache).get(resourceName);
    }

    public static Resource getResource(Globals globals, RequestCache cache, Collection<String> bundles, String resourceName) {
        String key;
        Resource resource = null;
        Iterator<String> i$ = bundles.iterator();
        while (i$.hasNext() && (resource = Helpers.getResource(globals, cache, key = i$.next(), resourceName)) == null) {
        }
        return resource;
    }

    public static Collection<String> resolveBundles(Globals globals, Collection<String> included, Collection<String> excluded, boolean resolveDeepDependencies, boolean includeLegacy, Map<String, String> httpParams) {
        LinkedHashSet<String> includedResolved = Helpers.resolveDependencies(globals, included, Sets.newHashSet(excluded), resolveDeepDependencies, includeLegacy, Helpers.isConditionSatisfiedPredicate(httpParams));
        includedResolved.removeAll(Helpers.resolveDependencies(globals, excluded, true, includeLegacy));
        return includedResolved;
    }

    public static Content transform(final Globals globals, final String type, final Supplier<Collection<Resource>> resources, final Map<String, String> params) {
        return new ContentImpl(null, true){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                ResourceContentAnnotator[] annotators = globals.getConfig().getContentAnnotators(type);
                try {
                    SourceMapJoiner sourceMapJoiner = isSourceMapEnabled ? new SourceMapJoiner() : new SourceMapJoinerStub();
                    boolean isFirst = true;
                    for (Resource resource : (Collection)resources.get()) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            out.write(10);
                        }
                        int offset = 0;
                        LineCountingProxyOutputStream lineCountingStream = new LineCountingProxyOutputStream(out);
                        if (isSourceMapEnabled) {
                            out = lineCountingStream;
                        }
                        for (ResourceContentAnnotator annotator : annotators) {
                            offset += annotator.beforeOffset();
                            annotator.before(resource, out);
                        }
                        Content content = Helpers.transform(globals, resource, params);
                        SourceMap sourceMap = content.writeTo(out, isSourceMapEnabled);
                        int resourceLength = lineCountingStream.getLinesCount() - offset;
                        for (int i = annotators.length - 1; i >= 0; --i) {
                            annotators[i].after(resource, out);
                        }
                        if (isSourceMapEnabled && sourceMap == null) {
                            String singleResourceUrl = globals.getRouter().resourceUrlWithoutHash(resource, params);
                            sourceMap = Util.create1to1SourceMap((int)resourceLength, (String)singleResourceUrl);
                        }
                        sourceMapJoiner.add(sourceMap, lineCountingStream.getLinesCount(), offset);
                    }
                    return sourceMapJoiner.join();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    public static Content transform(Globals globals, Resource resource, Map<String, String> params) {
        Preconditions.checkArgument((!resource.isRedirect() ? 1 : 0) != 0, (Object)"can't transform redirect resource!");
        Content content = resource.getContent();
        if (!resource.isTransformable()) {
            return content;
        }
        String sourceUrl = globals.getRouter().sourceUrl(resource);
        content = Helpers.applyTransformers(globals, resource, content, params, sourceUrl);
        content = Helpers.applyStaticTransformers(globals, resource, content, params, sourceUrl);
        return content;
    }

    protected static Content applyTransformers(Globals globals, Resource resource, Content content, Map<String, String> params, String sourceUrl) {
        if (resource.getParent() instanceof WebResource) {
            WebResource webResource = (WebResource)resource.getParent();
            List<WebResourceTransformation> transformations = webResource.getTransformations();
            if (transformations == null || transformations.isEmpty()) {
                return content;
            }
            Content lastContent = content;
            for (WebResourceTransformation transformation : transformations) {
                if (!transformation.matches(resource.getResourceLocation())) continue;
                lastContent = transformation.transform(globals.getConfig().getTransformerCache(), lastContent, resource.getResourceLocation(), webResource.getPluginKey(), resource.getFilePath(), webResource.getWebResourceKey(), QueryParams.of(params), sourceUrl);
            }
            return lastContent;
        }
        return content;
    }

    protected static Content applyStaticTransformers(Globals globals, Resource resource, Content content, Map<String, String> params, String sourceUrl) {
        if (resource.getParent() instanceof WebResource) {
            WebResource webResource = (WebResource)resource.getParent();
            return globals.getConfig().getStaticTransformers().transform(content, new TransformerParameters(webResource.getPluginKey(), webResource.getWebResourceKey()), resource.getResourceLocation(), QueryParams.of(params), sourceUrl);
        }
        return content;
    }

    public static Collection<Resource> selectForBatch(Collection<Resource> resources, String type, Map<String, String> params) {
        LinkedList<Resource> selected = new LinkedList<Resource>();
        for (Resource resource : resources) {
            if (!type.equals(resource.getType()) || !resource.isBatchable(params)) continue;
            selected.add(resource);
        }
        return selected;
    }

    protected static LinkedHashSet<String> resolveDependencies(Globals globals, Collection<String> included, boolean resolveDeepDependencies, boolean includeLegacy) {
        return Helpers.resolveDependencies(globals, included, new HashSet<String>(), resolveDeepDependencies, includeLegacy, (Predicate<Bundle>)Predicates.alwaysTrue());
    }

    protected static LinkedHashSet<String> resolveDependencies(Globals globals, Collection<String> included, Set<String> excluded, boolean resolveDeepDependencies, boolean includeLegacy, Predicate<Bundle> isIncluded) {
        LinkedHashSet<String> dependencies = new LinkedHashSet<String>();
        for (String key : included) {
            if (excluded.contains(key)) continue;
            Helpers.resolveBundleDependencies(globals, key, excluded, new LinkedHashSet<String>(), resolveDeepDependencies, includeLegacy, isIncluded, dependencies);
        }
        return dependencies;
    }

    protected static void resolveBundleDependencies(Globals globals, String key, Set<String> excluded, Set<String> stack, boolean resolveDeepDependencies, boolean includeLegacy, Predicate<Bundle> isIncluded, LinkedHashSet<String> dependencies) {
        if (dependencies.contains(key)) {
            return;
        }
        if (excluded.contains(key)) {
            return;
        }
        if (!stack.add(key)) {
            globals.getLogger().warn("cyclic plugin resource dependency has been detected with: {}, stack trace: {}", (Object)key, stack);
            return;
        }
        Bundle bundle = globals.getBundles().get(key);
        if (bundle != null && isIncluded.apply((Object)bundle) && (includeLegacy || !bundle.hasLegacyConditions())) {
            if (resolveDeepDependencies) {
                for (String dependencyKey : bundle.getDependencies()) {
                    Helpers.resolveBundleDependencies(globals, dependencyKey, excluded, stack, true, includeLegacy, isIncluded, dependencies);
                }
            }
            dependencies.add(key);
        }
        stack.remove(key);
    }

    public static boolean equals(Object a, Object b) {
        return a == null ? b == null : a.equals(b);
    }

    @Deprecated
    public static Resource getResourceRelativeToWebResource(Globals globals, RequestCache cache, String completeKey, String resourceName) {
        Bundle bundle = globals.getBundles().get(completeKey);
        if (bundle == null) {
            return null;
        }
        String filePath = "";
        Resource resource = null;
        while (resource == null) {
            String[] parts = Helpers.splitLastPathPart(resourceName);
            if (parts == null) {
                return null;
            }
            resourceName = parts[0];
            filePath = parts[1] + filePath;
            resource = bundle.getResources(cache).get(resourceName);
        }
        final String finalFilePath = filePath;
        return new Resource(resource.getParent(), resource.getResourceLocation(), resource.getType(), resource.isBatchable(), resource.isRedirect(), resource.isCacheable()){

            @Override
            public String getFilePath() {
                return finalFilePath;
            }
        };
    }

    @Deprecated
    public static Resource getResourceRelativeToPlugin(Globals globals, String completeKeyOrPluginKey, String resourceName) {
        String pluginKey = Helpers.getPluginKey(completeKeyOrPluginKey);
        String filePath = "";
        Resource resource = null;
        while (resource == null) {
            String[] parts = Helpers.splitLastPathPart(resourceName);
            if (parts == null) {
                return null;
            }
            resourceName = parts[0];
            filePath = parts[1] + filePath;
            resource = globals.getConfig().getPluginResource(pluginKey, resourceName);
        }
        final String finalFilePath = filePath;
        return new Resource(resource.getParent(), resource.getResourceLocation(), resource.getType(), resource.isBatchable(), resource.isRedirect(), resource.isCacheable()){

            @Override
            public String getFilePath() {
                return finalFilePath;
            }
        };
    }

    @Deprecated
    protected static String[] splitLastPathPart(String resourcePath) {
        int indexOfSlash = resourcePath.lastIndexOf(47);
        if (resourcePath.endsWith("/")) {
            indexOfSlash = resourcePath.lastIndexOf(47, indexOfSlash - 1);
        }
        if (indexOfSlash < 0) {
            return null;
        }
        return new String[]{resourcePath.substring(0, indexOfSlash + 1), resourcePath.substring(indexOfSlash + 1)};
    }

    public static String getPluginKey(String completeKeyOrPluginKey) {
        return completeKeyOrPluginKey.split(":")[0];
    }

    public static DownloadableResource asDownloadableResource(final Content content) {
        return new DownloadableResource(){

            public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
                throw new RuntimeException("not supported for content wrapper!");
            }

            public void serveResource(HttpServletRequest request, HttpServletResponse response) {
                throw new RuntimeException("not supported for content wrapper!");
            }

            public void streamResource(OutputStream out) {
                content.writeTo(out, false);
            }

            public String getContentType() {
                return content.getContentType();
            }
        };
    }

    public static Content asContent(final DownloadableResource downloadableResource, final SourceMap sourceMap, boolean isTransformed) {
        return new ContentImpl(downloadableResource.getContentType(), isTransformed){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                try {
                    downloadableResource.streamResource(out);
                }
                catch (DownloadException e) {
                    throw new RuntimeException(e);
                }
                return sourceMap;
            }
        };
    }

    public static Content buildEmptyContent(Content content) {
        return new ContentImpl(content.getContentType(), false){

            @Override
            public SourceMap writeTo(OutputStream out, boolean isSourceMapEnabled) {
                return null;
            }
        };
    }
}

