/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.annotations.Internal;
import com.atlassian.plugin.cache.filecache.Cache;
import com.atlassian.plugin.cache.filecache.impl.FileCacheImpl;
import com.atlassian.plugin.cache.filecache.impl.PassThroughCache;
import com.atlassian.plugin.webresource.Bundle;
import com.atlassian.plugin.webresource.Config;
import com.atlassian.plugin.webresource.http.Router;
import com.atlassian.plugin.webresource.support.ResettableLazyReferenceWithVersionCheck;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class Globals {
    private final Config config;
    private final Logger logger = LoggerFactory.getLogger((String)"webresource");
    private final ResettableLazyReferenceWithVersionCheck<Map<String, Bundle>> cachedBundles;
    private final List<StateChangeCallback> stateChangeCallbacks;
    private Router router;
    private Cache cache;

    public Globals(final Config config) {
        this.config = config;
        this.stateChangeCallbacks = new ArrayList<StateChangeCallback>();
        this.cachedBundles = new ResettableLazyReferenceWithVersionCheck<Map<String, Bundle>>(){

            @Override
            protected Map<String, Bundle> create() {
                return config.getWebResourcesWithoutCache();
            }

            @Override
            protected int getVersion() {
                return config.partialHashCode();
            }
        };
        this.onStateChange(new StateChangeCallback(){

            @Override
            public void apply() {
                Globals.this.cachedBundles.reset();
            }
        });
    }

    public Config getConfig() {
        return this.config;
    }

    public Router getRouter() {
        return this.router;
    }

    public void setRouter(Router router) {
        if (this.router != null) {
            throw new RuntimeException("router already set!");
        }
        this.router = router;
    }

    public Cache getCache() {
        return this.cache;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void onStateChange(StateChangeCallback callback) {
        this.stateChangeCallbacks.add(callback);
    }

    public void triggerStateChange() {
        for (StateChangeCallback callback : this.stateChangeCallbacks) {
            callback.apply();
        }
    }

    public void buildAndSetCache() {
        if (this.cache != null) {
            throw new RuntimeException("cache already set!");
        }
        if (this.config.isCacheEnabled()) {
            try {
                this.cache = new FileCacheImpl(this.config.getCacheDirectory(), this.config.getCacheSize());
                this.onStateChange(new StateChangeCallback(){

                    @Override
                    public void apply() {
                        Globals.this.cache.clear();
                    }
                });
            }
            catch (Exception e) {
                this.logger.error("Could not create file cache object, will startup with filecaching disabled, please investigate the cause and correct it.", (Throwable)e);
                this.cache = new PassThroughCache();
            }
        } else {
            this.cache = new PassThroughCache();
        }
    }

    public Map<String, Bundle> getBundles() {
        return this.cachedBundles.get();
    }

    static interface StateChangeCallback {
        public void apply();
    }
}

