/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.url;

import com.atlassian.plugin.webresource.url.CDNSupport;
import com.atlassian.plugin.webresource.url.NamedHash;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UrlParameters {
    private static final UrlParameters EMPTY_CDN_OK = new UrlParameters(CDNSupport.OK);
    private static final UrlParameters EMPTY_CDN_TAINTED = new UrlParameters(CDNSupport.Tainted);
    private final List<NamedHash> hashes;
    private final Map<String, String> queryString;
    private final CDNSupport cdn;

    public static UrlParameters of(CDNSupport cdn) {
        switch (cdn) {
            case OK: {
                return EMPTY_CDN_OK;
            }
            case Tainted: {
                return EMPTY_CDN_TAINTED;
            }
        }
        throw new AssertionError((Object)("Unhandled CDNSupport parameter: " + (Object)((Object)cdn)));
    }

    public static UrlParameters of(CDNSupport cdn, List<NamedHash> hashes, Map<String, String> queryString) {
        return new UrlParameters(cdn, hashes, queryString);
    }

    private UrlParameters(CDNSupport cdn) {
        this(cdn, Collections.emptyList(), Collections.emptyMap());
    }

    private UrlParameters(CDNSupport cdn, List<NamedHash> hashes, Map<String, String> queryString) {
        this.cdn = cdn;
        this.hashes = ImmutableList.copyOf(hashes);
        this.queryString = ImmutableMap.copyOf(queryString);
    }

    public List<NamedHash> allHashes() {
        return this.hashes;
    }

    public Map<String, String> toQueryString() {
        return this.queryString;
    }

    public CDNSupport supportsCdn() {
        return this.cdn;
    }

    public UrlParameters merge(UrlParameters other) {
        HashMap mergedQueryString = Maps.newHashMap(this.queryString);
        mergedQueryString.putAll(other.queryString);
        ImmutableList mergedHashes = ImmutableList.copyOf((Iterable)Iterables.concat(this.hashes, other.hashes));
        CDNSupport mergedCdn = this.cdn.combine(other.cdn);
        return new UrlParameters(mergedCdn, (List<NamedHash>)mergedHashes, mergedQueryString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlParameters that = (UrlParameters)o;
        if (this.cdn != that.cdn) {
            return false;
        }
        if (!this.hashes.equals(that.hashes)) {
            return false;
        }
        return this.queryString.equals(that.queryString);
    }

    public int hashCode() {
        int result = this.hashes.hashCode();
        result = 31 * result + this.queryString.hashCode();
        result = 31 * result + this.cdn.hashCode();
        return result;
    }
}

