/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.transformer;

import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.StaticTransformersSupplier;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerFactory;
import com.atlassian.plugin.webresource.url.UrlBuilder;

public class DefaultStaticTransformers
implements StaticTransformers {
    private final StaticTransformersSupplier staticTransformersSupplier;

    public DefaultStaticTransformers(StaticTransformersSupplier staticTransformersSupplier) {
        this.staticTransformersSupplier = staticTransformersSupplier;
    }

    @Override
    public void addToUrl(String type, TransformerParameters transformerParameters, UrlBuilder urlBuilder) {
        for (WebResourceTransformerFactory transformerFactory : this.transformersForType(type)) {
            transformerFactory.makeUrlBuilder(transformerParameters).addToUrl(urlBuilder);
        }
    }

    @Override
    public DownloadableResource transform(TransformerParameters transformerParameters, TransformableResource resource, QueryParams queryParams) {
        TransformableResource lastResource = resource;
        for (WebResourceTransformerFactory transformerFactory : this.transformersForLocation(resource.location())) {
            DownloadableResource currentResource = transformerFactory.makeResourceTransformer(transformerParameters).transform(lastResource, queryParams);
            lastResource = new TransformableResource(lastResource.location(), lastResource.filePath(), currentResource);
        }
        return lastResource.nextResource();
    }

    private Iterable<WebResourceTransformerFactory> transformersForType(String type) {
        return this.staticTransformersSupplier.get(type);
    }

    private Iterable<WebResourceTransformerFactory> transformersForLocation(ResourceLocation location) {
        return this.staticTransformersSupplier.get(location);
    }
}

