/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.assembler;

import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.assembler.InclusionState;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.transformer.StaticTransformers;
import com.atlassian.plugin.webresource.transformer.TransformerCache;
import com.atlassian.plugin.webresource.url.DefaultUrlBuilderMap;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WebResourceSetCache {
    private static final Logger log = LoggerFactory.getLogger(WebResourceSetCache.class);
    private static final String RESOURCE_TO_CONDITION_LIST_CACHE_NAME = "resourceToConditionList";
    private static final String RESOURCE_AND_CONDITIONS_TO_SET_CACHE_NAME = "resourceAndConditionsToSet";
    private static final boolean CACHE_ENABLED = Boolean.valueOf(System.getProperty("plugin.webresource.tagcache.enabled", "true"));
    private final Cache<WebResourceSetCacheKey, WebResourceSetConditionEntry> resourceToConditionListCache;
    private final Cache<ResourceAndConditionStateKey, WebResourceSetEntry> resourceAndConditionToSetCache;
    private final StaticTransformers staticTransformers;

    WebResourceSetCache(CacheFactory cacheFactory, StaticTransformers staticTransformers) {
        this.staticTransformers = staticTransformers;
        CacheSettings resourceToConditionListCacheSettings = new CacheSettingsBuilder().local().build();
        this.resourceToConditionListCache = WebResourceSetCache.getCache(cacheFactory, WebResourceSetCache.class, RESOURCE_TO_CONDITION_LIST_CACHE_NAME, resourceToConditionListCacheSettings);
        CacheSettings resourceAndConditionToSetCacheSettings = new CacheSettingsBuilder().local().build();
        this.resourceAndConditionToSetCache = WebResourceSetCache.getCache(cacheFactory, WebResourceSetCache.class, RESOURCE_AND_CONDITIONS_TO_SET_CACHE_NAME, resourceAndConditionToSetCacheSettings);
    }

    private static <K, V> Cache<K, V> getCache(CacheFactory cacheFactory, Class<?> owningClass, String name, CacheSettings required) {
        String cacheName = owningClass.getName() + "." + name;
        return cacheFactory.getCache(cacheName, null, required);
    }

    public Option<WebResourceSetEntry> get(WebResourceSetCacheKey key, TransformerCache transformerCache) {
        Map<String, UrlParameters> parameters;
        if (!CACHE_ENABLED) {
            return Option.none();
        }
        WebResourceSetConditionEntry conditionCache = (WebResourceSetConditionEntry)this.resourceToConditionListCache.get((Object)key);
        if (conditionCache == null) {
            log.debug("No entry for key: {}", (Object)key);
            return Option.none();
        }
        ConditionState currentState = this.getCurrentConditionState(new ConditionState(), conditionCache);
        ConditionStateKey stateKey = new ConditionStateKey(currentState, parameters = this.getCurrentParameters(conditionCache, transformerCache));
        ResourceAndConditionStateKey secondaryKey = new ResourceAndConditionStateKey(key, stateKey);
        WebResourceSetEntry entry = (WebResourceSetEntry)this.resourceAndConditionToSetCache.get((Object)secondaryKey);
        if (entry != null) {
            log.debug("Conditions are fair for key: {}", (Object)key);
            return Option.some((Object)entry.copy());
        }
        log.debug("Still no entry for key: {}", (Object)key);
        return Option.none();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(WebResourceSetCacheKey key, ConditionState conditionsRun, InclusionState inclusion, DefaultWebResourceSet.Builder set, TransformerCache transformerCache) {
        if (!CACHE_ENABLED) {
            return;
        }
        WebResourceSetConditionEntry conditionCache = (WebResourceSetConditionEntry)this.resourceToConditionListCache.get((Object)key);
        while (conditionCache == null) {
            this.resourceToConditionListCache.putIfAbsent((Object)key, (Object)new WebResourceSetConditionEntry());
            conditionCache = (WebResourceSetConditionEntry)this.resourceToConditionListCache.get((Object)key);
        }
        Object object = conditionCache.lock;
        synchronized (object) {
            Object stateKey2;
            boolean conditionsChanged = conditionCache.allConditionsToRun.addAll(conditionsRun.getConditions());
            boolean resourceTypesChanged = conditionCache.allResourceTypes.addAll(conditionsRun.getResourceTypes());
            boolean modulesChanged = conditionCache.allWebResourceModuleDescriptors.addAll(conditionsRun.getWebResourceModuleDescriptors());
            if (conditionsChanged || resourceTypesChanged || modulesChanged) {
                Collection keys = this.resourceAndConditionToSetCache.getKeys();
                for (Object stateKey2 : keys) {
                    if (!((ResourceAndConditionStateKey)stateKey2).matches(key)) continue;
                    this.resourceAndConditionToSetCache.remove(stateKey2);
                }
            }
            ConditionState allConditionsRun = this.getCurrentConditionState(conditionsRun, conditionCache);
            Map<String, UrlParameters> parameters = this.getCurrentParameters(conditionCache, transformerCache);
            stateKey2 = new ConditionStateKey(allConditionsRun, parameters);
            ResourceAndConditionStateKey secondaryKey = new ResourceAndConditionStateKey(key, (ConditionStateKey)stateKey2);
            this.resourceAndConditionToSetCache.put((Object)secondaryKey, (Object)new WebResourceSetEntry(conditionsRun.getWebResourceModuleDescriptors(), inclusion, set));
        }
    }

    private ConditionState getCurrentConditionState(ConditionState conditionsRun, WebResourceSetConditionEntry conditionCache) {
        ConditionState allConditionsRun = new ConditionState();
        for (DecoratingCondition condition : conditionCache.allConditionsToRun) {
            Boolean value = conditionsRun.getConditionResult(condition);
            if (value == null) {
                value = condition.shouldDisplayImmediate((Map<String, Object>)ImmutableMap.of());
            }
            allConditionsRun.addCondition(condition, value);
        }
        return allConditionsRun;
    }

    private Map<String, UrlParameters> getCurrentParameters(WebResourceSetConditionEntry conditionCache, TransformerCache transformerCache) {
        HashMap<String, UrlParameters> params = new HashMap<String, UrlParameters>();
        DefaultUrlBuilderMap urlBuilderMap = new DefaultUrlBuilderMap(conditionCache.allWebResourceModuleDescriptors, transformerCache, this.staticTransformers);
        Set<String> resourceTypes = conditionCache.allResourceTypes;
        for (String resourceType : resourceTypes) {
            params.put(resourceType, this.getCurrentParameters(urlBuilderMap, resourceType));
        }
        return params;
    }

    private UrlParameters getCurrentParameters(DefaultUrlBuilderMap urlBuilderMap, String resourceType) {
        ConditionState conditionsRun = new ConditionState();
        return urlBuilderMap.getOrCreateForType(resourceType, conditionsRun);
    }

    public void clear() {
        this.resourceToConditionListCache.removeAll();
        this.resourceAndConditionToSetCache.removeAll();
    }

    public int numIncludeVariants() {
        return this.resourceToConditionListCache.getKeys().size();
    }

    public int numEntries() {
        return this.resourceAndConditionToSetCache.getKeys().size();
    }

    public static class WebResourceSetCacheKey {
        private final Set<String> requiredWebResources;
        private final Set<String> requiredContexts;
        private final Set<String> requiredDataKeys;
        private final WebResourceFilter filter;
        private final InclusionState startingInclusionState;

        public WebResourceSetCacheKey(Set<String> requiredWebResources, Set<String> requiredContexts, Set<String> requiredDataKeys, WebResourceFilter filter, InclusionState startingInclusionState) {
            this.requiredWebResources = ImmutableSet.copyOf(requiredWebResources);
            this.requiredContexts = ImmutableSet.copyOf(requiredContexts);
            this.requiredDataKeys = ImmutableSet.copyOf(requiredDataKeys);
            this.filter = filter;
            this.startingInclusionState = startingInclusionState.copy();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            WebResourceSetCacheKey that = (WebResourceSetCacheKey)o;
            if (this.filter != null ? !this.filter.equals(that.filter) : that.filter != null) {
                return false;
            }
            if (this.startingInclusionState != null ? !this.startingInclusionState.equals(that.startingInclusionState) : that.startingInclusionState != null) {
                return false;
            }
            if (this.requiredContexts != null ? !this.requiredContexts.equals(that.requiredContexts) : that.requiredContexts != null) {
                return false;
            }
            if (this.requiredDataKeys != null ? !this.requiredDataKeys.equals(that.requiredDataKeys) : that.requiredDataKeys != null) {
                return false;
            }
            return !(this.requiredWebResources != null ? !this.requiredWebResources.equals(that.requiredWebResources) : that.requiredWebResources != null);
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.requiredWebResources != null ? this.requiredWebResources.hashCode() : 0);
            result = 31 * result + (this.requiredContexts != null ? this.requiredContexts.hashCode() : 0);
            result = 31 * result + (this.requiredDataKeys != null ? this.requiredDataKeys.hashCode() : 0);
            result = 31 * result + (this.filter != null ? this.filter.hashCode() : 0);
            result = 31 * result + (this.startingInclusionState != null ? this.startingInclusionState.hashCode() : 0);
            return result;
        }

        public String toString() {
            return "WebResourceSetCacheKey{requiredWebResources=" + this.requiredWebResources + ", requiredContexts=" + this.requiredContexts + ", requiredDataKeys=" + this.requiredDataKeys + ", filter=" + this.filter + ", inclusion=" + this.startingInclusionState + '}';
        }
    }

    public static class WebResourceSetEntry {
        private final Iterable<WebResourceModuleDescriptor> includedModules;
        private final InclusionState resultingInclusionState;
        private final DefaultWebResourceSet.Builder builder;

        public WebResourceSetEntry(Iterable<WebResourceModuleDescriptor> includedModules, InclusionState resultingInclusionState, DefaultWebResourceSet.Builder builder) {
            Preconditions.checkNotNull((Object)builder);
            this.includedModules = includedModules;
            this.resultingInclusionState = resultingInclusionState;
            this.builder = builder.copy();
        }

        public Iterable<WebResourceModuleDescriptor> includedModules() {
            return this.includedModules;
        }

        public InclusionState inclusion() {
            return this.resultingInclusionState;
        }

        public DefaultWebResourceSet.Builder webResourceSet() {
            return this.builder;
        }

        public WebResourceSetEntry copy() {
            return new WebResourceSetEntry(this.includedModules, this.resultingInclusionState, this.builder);
        }
    }

    public static class ConditionStateKey {
        private final ConditionState conditionState;
        private final Map<String, UrlParameters> urlParameters;

        public ConditionStateKey(ConditionState conditionState, Map<String, UrlParameters> urlParameters) {
            this.conditionState = conditionState;
            this.urlParameters = urlParameters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConditionStateKey that = (ConditionStateKey)o;
            if (!this.conditionState.equals(that.conditionState)) {
                return false;
            }
            return this.urlParameters.equals(that.urlParameters);
        }

        public int hashCode() {
            int result = this.conditionState.hashCode();
            result = 31 * result + this.urlParameters.hashCode();
            return result;
        }
    }

    public static class WebResourceSetConditionEntry {
        final Object lock = new Object();
        Set<DecoratingCondition> allConditionsToRun = new HashSet<DecoratingCondition>();
        Set<String> allResourceTypes = new HashSet<String>();
        Set<WebResourceModuleDescriptor> allWebResourceModuleDescriptors = new HashSet<WebResourceModuleDescriptor>();
    }

    public static class ResourceAndConditionStateKey {
        private final WebResourceSetCacheKey webResourceSetCacheKey;
        private final ConditionStateKey conditionStateKey;

        public ResourceAndConditionStateKey(WebResourceSetCacheKey webResourceSetCacheKey, ConditionStateKey conditionStateKey) {
            this.webResourceSetCacheKey = webResourceSetCacheKey;
            this.conditionStateKey = conditionStateKey;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ResourceAndConditionStateKey that = (ResourceAndConditionStateKey)o;
            if (!this.conditionStateKey.equals(that.conditionStateKey)) {
                return false;
            }
            return this.webResourceSetCacheKey.equals(that.webResourceSetCacheKey);
        }

        public int hashCode() {
            int result = this.webResourceSetCacheKey.hashCode();
            result = 31 * result + this.conditionStateKey.hashCode();
            return result;
        }

        public boolean matches(WebResourceSetCacheKey key) {
            return this.webResourceSetCacheKey.equals(key);
        }
    }
}

