/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.url;

import com.atlassian.plugin.webresource.url.CDNSupport;
import com.atlassian.plugin.webresource.url.NamedHash;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.atlassian.plugin.webresource.url.UrlParameters;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;

public class DefaultUrlBuilder
implements UrlBuilder {
    private final List<NamedHash> hashes;
    private final Map<String, String> queryString;
    private CDNSupport cdn = CDNSupport.OK;

    public DefaultUrlBuilder() {
        this.hashes = Lists.newLinkedList();
        this.queryString = Maps.newLinkedHashMap();
    }

    @Override
    public void addToHash(String name, Object value) {
        this.hashes.add(new NamedHash(name, value.toString()));
    }

    @Override
    public void addToQueryString(String key, String value) {
        this.queryString.put(key, value);
    }

    public void taint() {
        this.cdn = CDNSupport.Tainted;
    }

    public UrlParameters build() {
        return UrlParameters.of(this.cdn, this.hashes, this.queryString);
    }
}

