/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.fugue.Either;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.elements.ResourceLocation;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.TransformableResource;
import com.atlassian.plugin.webresource.transformer.TransformerParameters;
import com.atlassian.plugin.webresource.transformer.UrlReadingWebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.transformer.WebResourceTransformerModuleDescriptor;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.lang.Validate;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebResourceTransformation {
    private final String extension;
    private final String type;
    private final Map<String, Element> transformerElements;
    private Logger log = LoggerFactory.getLogger(WebResourceTransformation.class);

    public WebResourceTransformation(Element element) {
        Validate.notNull((Object)element.attribute("extension"));
        this.type = element.attributeValue("extension");
        this.extension = "." + this.type;
        LinkedHashMap<String, Element> transformers = new LinkedHashMap<String, Element>();
        for (Element transformElement : element.elements("transformer")) {
            transformers.put(transformElement.attributeValue("key"), transformElement);
        }
        this.transformerElements = Collections.unmodifiableMap(transformers);
    }

    public boolean matches(ResourceLocation location) {
        String loc = location.getLocation();
        if (loc == null || "".equals(loc.trim())) {
            loc = location.getName();
        }
        return loc.endsWith(this.extension);
    }

    public boolean matches(String location) {
        return location.equals(this.type);
    }

    public void addTransformParameters(PluginAccessor pluginAccessor, WebResourceModuleDescriptor webResourceModuleDescriptor, UrlBuilder urlBuilder) {
        for (Map.Entry<String, Element> entry : this.transformerElements.entrySet()) {
            Option<Either<UrlReadingWebResourceTransformerModuleDescriptor, WebResourceTransformerModuleDescriptor>> t = this.transformerForKey(pluginAccessor, entry.getKey());
            if (!t.isDefined() || !((Either)t.get()).isLeft()) continue;
            UrlReadingWebResourceTransformerModuleDescriptor descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)((Either)t.get()).left().get());
            descriptor.getModule().makeUrlBuilder(TransformerParameters.of(webResourceModuleDescriptor)).addToUrl(urlBuilder);
        }
    }

    public boolean containsOnlyPureUrlReadingTransformers(PluginAccessor pluginAccessor) {
        for (Map.Entry<String, Element> entry : this.transformerElements.entrySet()) {
            Option<Either<UrlReadingWebResourceTransformerModuleDescriptor, WebResourceTransformerModuleDescriptor>> t = this.transformerForKey(pluginAccessor, entry.getKey());
            if (!t.isDefined() || !((Either)t.get()).isRight()) continue;
            return false;
        }
        return true;
    }

    public Iterable<WebResourceTransformerModuleDescriptor> getDeprecatedTransformers(PluginAccessor pluginAccessor) {
        ArrayList<WebResourceTransformerModuleDescriptor> result = new ArrayList<WebResourceTransformerModuleDescriptor>();
        for (Map.Entry<String, Element> entry : this.transformerElements.entrySet()) {
            Option<Either<UrlReadingWebResourceTransformerModuleDescriptor, WebResourceTransformerModuleDescriptor>> t = this.transformerForKey(pluginAccessor, entry.getKey());
            if (!t.isDefined() || !((Either)t.get()).isRight()) continue;
            result.add((WebResourceTransformerModuleDescriptor)((Object)((Either)t.get()).right().get()));
        }
        return result;
    }

    public DownloadableResource transformDownloadableResource(PluginAccessor pluginAccessor, WebResourceModuleDescriptor webResourceModuleDescriptor, DownloadableResource resource, ResourceLocation resourceLocation, String filePath, QueryParams params) {
        DownloadableResource lastResource = resource;
        for (Map.Entry<String, Element> entry : this.transformerElements.entrySet()) {
            Option<Either<UrlReadingWebResourceTransformerModuleDescriptor, WebResourceTransformerModuleDescriptor>> t = this.transformerForKey(pluginAccessor, entry.getKey());
            if (t.isDefined()) {
                AbstractModuleDescriptor descriptor;
                if (((Either)t.get()).isLeft()) {
                    descriptor = (UrlReadingWebResourceTransformerModuleDescriptor)((Object)((Either)t.get()).left().get());
                    TransformableResource transformableResource = new TransformableResource(resourceLocation, filePath, lastResource);
                    lastResource = descriptor.getModule().makeResourceTransformer(TransformerParameters.of(webResourceModuleDescriptor)).transform(transformableResource, params);
                    continue;
                }
                descriptor = (WebResourceTransformerModuleDescriptor)((Object)((Either)t.get()).right().get());
                lastResource = descriptor.getModule().transform(entry.getValue(), resourceLocation, filePath, lastResource);
                continue;
            }
            this.log.warn("Web resource transformer {} not found for resource {}, skipping", (Object)entry.getKey(), (Object)resourceLocation.getName());
        }
        return lastResource;
    }

    private Option<Either<UrlReadingWebResourceTransformerModuleDescriptor, WebResourceTransformerModuleDescriptor>> transformerForKey(PluginAccessor pluginAccessor, String key) {
        Iterator<AbstractModuleDescriptor> i$ = this.urlReadingTransformersByKey(pluginAccessor, key).iterator();
        if (i$.hasNext()) {
            UrlReadingWebResourceTransformerModuleDescriptor descriptor = i$.next();
            return Option.some((Object)Either.left((Object)((Object)descriptor)));
        }
        i$ = this.urlReadingTransformersByAliasKey(pluginAccessor, key).iterator();
        if (i$.hasNext()) {
            UrlReadingWebResourceTransformerModuleDescriptor descriptor = i$.next();
            return Option.some((Object)Either.left((Object)((Object)descriptor)));
        }
        i$ = this.transformersByKey(pluginAccessor, key).iterator();
        if (i$.hasNext()) {
            WebResourceTransformerModuleDescriptor descriptor = (WebResourceTransformerModuleDescriptor)i$.next();
            return Option.some((Object)Either.right((Object)((Object)descriptor)));
        }
        return Option.none();
    }

    private Iterable<UrlReadingWebResourceTransformerModuleDescriptor> urlReadingTransformersByKey(PluginAccessor pluginAccessor, String key) {
        return this.transformersByKey(pluginAccessor, UrlReadingWebResourceTransformerModuleDescriptor.class, key);
    }

    private Iterable<UrlReadingWebResourceTransformerModuleDescriptor> urlReadingTransformersByAliasKey(PluginAccessor pluginAccessor, final String key) {
        return Iterables.filter((Iterable)pluginAccessor.getEnabledModuleDescriptorsByClass(UrlReadingWebResourceTransformerModuleDescriptor.class), (Predicate)new Predicate<UrlReadingWebResourceTransformerModuleDescriptor>(){

            public boolean apply(@Nullable UrlReadingWebResourceTransformerModuleDescriptor descriptor) {
                String aliasKey = descriptor.getAliasKey();
                return aliasKey != null && aliasKey.equals(key);
            }
        });
    }

    private Iterable<WebResourceTransformerModuleDescriptor> transformersByKey(PluginAccessor pluginAccessor, String key) {
        return this.transformersByKey(pluginAccessor, WebResourceTransformerModuleDescriptor.class, key);
    }

    private <D extends ModuleDescriptor<?>> Iterable<D> transformersByKey(PluginAccessor pluginAccessor, Class<D> clazz, final String key) {
        return Iterables.filter((Iterable)pluginAccessor.getEnabledModuleDescriptorsByClass(clazz), (Predicate)new Predicate<D>(){

            public boolean apply(@Nullable D descriptor) {
                return descriptor.getKey().equals(key);
            }
        });
    }
}

