/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.ContextBatch;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceBatchParams;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.condition.ConditionState;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;

class ContextBatchOperations {
    static final String CONTEXT_SEPARATOR = ",";
    static final String CONTEXT_SUBTRACTION = "-";
    private PluginResourceLocator pluginResourceLocator;
    private final WebResourceFilter filter;

    static void parseContexts(String key, LinkedHashSet<String> included, Set<String> excluded) {
        String[] split;
        for (String s : split = key.split(CONTEXT_SEPARATOR)) {
            if (s.startsWith(CONTEXT_SUBTRACTION)) {
                excluded.add(s.substring(1));
                continue;
            }
            included.add(s);
        }
    }

    ContextBatchOperations(PluginResourceLocator pluginResourceLocator, WebResourceFilter filter) {
        this.pluginResourceLocator = pluginResourceLocator;
        this.filter = filter;
    }

    ContextBatch merge(Collection<ContextBatch> batchesToMerge) {
        if (CollectionUtils.isEmpty(batchesToMerge)) {
            return null;
        }
        if (batchesToMerge.size() == 1) {
            return batchesToMerge.iterator().next();
        }
        StringBuilder mergedKey = new StringBuilder();
        LinkedHashSet<String> includedContexts = new LinkedHashSet<String>();
        HashSet<WebResourceModuleDescriptor> resources = new HashSet<WebResourceModuleDescriptor>();
        HashSet<PluginResourceBatchParams> batchResourceParams = new HashSet<PluginResourceBatchParams>();
        boolean removeSuperResources = false;
        for (ContextBatch batch : batchesToMerge) {
            if (!Iterables.isEmpty(batch.getExcludedContexts())) {
                throw new IllegalArgumentException("The ContextBatch " + batch.getKey() + " has excludedContexts.");
            }
            removeSuperResources |= batch.isRemoveSuperResources();
            mergedKey.append(batch.getKey()).append(CONTEXT_SEPARATOR);
            includedContexts.addAll(batch.getContexts());
            Iterables.addAll(resources, batch.getResources());
            Iterables.addAll(batchResourceParams, batch.getResourceParams());
        }
        mergedKey.deleteCharAt(mergedKey.length() - 1);
        return new ContextBatch(mergedKey.toString(), new ArrayList<String>(includedContexts), null, resources, batchResourceParams, removeSuperResources);
    }

    ContextBatch subtract(ContextBatch operand, Collection<ContextBatch> batchesToSubtract, ConditionState conditionsRun) {
        if (CollectionUtils.isEmpty(batchesToSubtract)) {
            return operand;
        }
        LinkedHashSet<String> excludedContexts = new LinkedHashSet<String>();
        Iterables.addAll(excludedContexts, operand.getExcludedContexts());
        LinkedHashSet<WebResourceModuleDescriptor> resources = new LinkedHashSet<WebResourceModuleDescriptor>();
        Iterables.addAll(resources, operand.getResources());
        boolean removeSuperResources = false;
        for (ContextBatch subtract : batchesToSubtract) {
            if (!Iterables.isEmpty(subtract.getExcludedContexts())) {
                throw new IllegalArgumentException("The ContextBatch " + subtract.getKey() + " has excludedContexts.");
            }
            removeSuperResources |= subtract.isRemoveSuperResources();
            Iterables.addAll(excludedContexts, subtract.getContexts());
            Iterable<WebResourceModuleDescriptor> subtractResources = subtract.getResources();
            for (WebResourceModuleDescriptor resource : subtractResources) {
                resources.remove((Object)resource);
            }
        }
        String key = ContextBatchOperations.buildContextKey(operand.getContexts(), excludedContexts);
        ContextBatch subtractionResult = new ContextBatch(key, operand.getContexts(), excludedContexts, resources, new HashSet<PluginResourceBatchParams>(), removeSuperResources);
        for (WebResourceModuleDescriptor resource : resources) {
            for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(resource.getCompleteKey(), conditionsRun)) {
                if (!this.filter.matches(pluginResource.getResourceName())) continue;
                subtractionResult.addResourceType(pluginResource);
            }
        }
        return subtractionResult;
    }

    static String buildContextKey(Iterable<String> contexts, Iterable<String> excludedContexts) {
        StringBuilder key = new StringBuilder();
        for (String includedContext : contexts) {
            key.append(includedContext).append(CONTEXT_SEPARATOR);
        }
        for (String excludedContext : excludedContexts) {
            key.append(CONTEXT_SUBTRACTION).append(excludedContext).append(CONTEXT_SEPARATOR);
        }
        key.deleteCharAt(key.length() - 1);
        return key.toString();
    }
}

