/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.condition;

import com.atlassian.plugin.webresource.QueryParams;
import com.atlassian.plugin.webresource.condition.DecoratingCondition;
import com.atlassian.plugin.webresource.condition.UrlReadingCondition;
import com.atlassian.plugin.webresource.url.UrlBuilder;
import java.util.Map;

class DecoratingUrlReadingCondition
implements DecoratingCondition {
    protected final UrlReadingCondition urlReadingCondition;
    private final boolean invert;

    public DecoratingUrlReadingCondition(UrlReadingCondition urlReadingCondition) {
        this(urlReadingCondition, false);
    }

    public DecoratingUrlReadingCondition(UrlReadingCondition urlReadingCondition, boolean invert) {
        this.urlReadingCondition = urlReadingCondition;
        this.invert = invert;
    }

    @Override
    public void addToUrl(UrlBuilder urlBuilder) {
        this.urlReadingCondition.addToUrl(urlBuilder);
    }

    @Override
    public boolean canEncodeStateIntoUrl() {
        return true;
    }

    @Override
    public boolean shouldDisplayImmediate(Map<String, Object> context) {
        return true;
    }

    @Override
    public boolean shouldDisplay(QueryParams params) {
        boolean shouldDisplay = this.urlReadingCondition.shouldDisplay(params);
        return this.invert ? !shouldDisplay : shouldDisplay;
    }

    @Override
    public DecoratingCondition invertCondition() {
        return new DecoratingUrlReadingCondition(this.urlReadingCondition, !this.invert);
    }
}

