/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.elements.ResourceDescriptor;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.AbstractTransformResource;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.transformer.SearchAndReplacer;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class RelativeURLTransformResource
extends AbstractTransformResource {
    static final Pattern CSS_URL_PATTERN = Pattern.compile("url\\s*\\(\\s*+([\"'])?+(?!/|https?://|data:)");
    private final LazyReference<String> urlPrefix;

    static boolean matches(ResourceDescriptor resource) {
        return CssWebResource.FORMATTER.matches(resource.getName());
    }

    RelativeURLTransformResource(final WebResourceUrlProvider webResourceUrlProvider, final ModuleDescriptor<?> moduleDescriptor, DownloadableResource originalResource) {
        super(originalResource);
        this.urlPrefix = new LazyReference<String>(){

            protected String create() {
                String version = moduleDescriptor.getPlugin().getPluginInformation().getVersion();
                return webResourceUrlProvider.getStaticResourcePrefix(version, UrlMode.RELATIVE) + "/download/resources" + "/" + moduleDescriptor.getCompleteKey() + "/";
            }
        };
    }

    @Override
    CharSequence transform(CharSequence originalContent) {
        Function<Matcher, CharSequence> replacer = new Function<Matcher, CharSequence>(){

            public CharSequence apply(Matcher matcher) {
                return new StringBuilder(matcher.group()).append((String)RelativeURLTransformResource.this.urlPrefix.get());
            }
        };
        return SearchAndReplacer.create(CSS_URL_PATTERN, replacer).replaceAll(originalContent);
    }

    public String toString() {
        return "Relative URL Transform Resource: urlPrefix: " + this.urlPrefix + ", originalResource: " + this.originalResource.toString();
    }
}

