/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.atlassian.plugin.webresource.assembler.DefaultPageBuilderService;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceAssemblerFactory;
import com.atlassian.plugin.webresource.assembler.DefaultWebResourceSet;
import com.atlassian.plugin.webresource.assembler.LegacyPageBuilderService;
import com.atlassian.plugin.webresource.assembler.UrlModeUtils;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.RequiredResources;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceAssembler;
import com.atlassian.webresource.api.assembler.WebResourceAssemblerFactory;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class WebResourceManagerImpl
implements WebResourceManager {
    static final String STATIC_RESOURCE_PREFIX = "s";
    static final String STATIC_RESOURCE_SUFFIX = "_";
    private final WebResourceAssemblerFactory webResourceAssemblerFactory;
    protected final LegacyPageBuilderService pageBuilderService;
    protected final WebResourceIntegration webResourceIntegration;
    protected final PluginResourceLocator pluginResourceLocator;
    protected final WebResourceUrlProvider webResourceUrlProvider;
    protected final ResourceBatchingConfiguration batchingConfiguration;
    protected final ResourceDependencyResolver dependencyResolver;

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider) {
        this(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, new DefaultResourceBatchingConfiguration());
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        this(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, batchingConfiguration, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration));
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, ResourceDependencyResolver dependencyResolver) {
        this(new DefaultWebResourceAssemblerFactory(batchingConfiguration, webResourceIntegration, webResourceUrlProvider, pluginResourceLocator), pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, batchingConfiguration, dependencyResolver);
    }

    public WebResourceManagerImpl(WebResourceAssemblerFactory webResourceAssemblerFactory, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, ResourceDependencyResolver dependencyResolver) {
        this(webResourceAssemblerFactory, new DefaultPageBuilderService(webResourceIntegration, webResourceAssemblerFactory), pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, batchingConfiguration, dependencyResolver);
    }

    public WebResourceManagerImpl(WebResourceAssemblerFactory webResourceAssemblerFactory, LegacyPageBuilderService pageBuilderService, PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, ResourceDependencyResolver dependencyResolver) {
        this.webResourceAssemblerFactory = (WebResourceAssemblerFactory)Assertions.notNull((String)"webResourceAssemblerFactory", (Object)webResourceAssemblerFactory);
        this.pageBuilderService = (LegacyPageBuilderService)Assertions.notNull((String)"pageBuilderService", (Object)pageBuilderService);
        this.pluginResourceLocator = (PluginResourceLocator)Assertions.notNull((String)"pluginResourceLocator", (Object)pluginResourceLocator);
        this.webResourceIntegration = (WebResourceIntegration)Assertions.notNull((String)"webResourceIntegration", (Object)webResourceIntegration);
        this.webResourceUrlProvider = (WebResourceUrlProvider)Assertions.notNull((String)"webResourceUrlProvider", (Object)webResourceUrlProvider);
        this.batchingConfiguration = (ResourceBatchingConfiguration)Assertions.notNull((String)"batchingConfiguration", (Object)batchingConfiguration);
        this.dependencyResolver = (ResourceDependencyResolver)Assertions.notNull((String)"dependencyResolver", (Object)dependencyResolver);
    }

    @Override
    public void requireResource(String moduleCompleteKey) {
        this.getRequestLocalRequiredResources().requireWebResource(moduleCompleteKey);
    }

    @Override
    public void requireResourcesForContext(String context) {
        this.getRequestLocalRequiredResources().requireContext(context);
    }

    @Override
    public void includeResources(Iterable<String> moduleCompleteKeys, Writer writer, UrlMode urlMode) {
        WebResourceAssembler webResourceAssembler = this.createSuperbatchingDisabledWebResourceAssembler();
        for (String moduleCompleteKey : moduleCompleteKeys) {
            webResourceAssembler.resources().requireWebResource(moduleCompleteKey);
        }
        WebResourceSet webResourceSet = webResourceAssembler.assembled().drainIncludedResources();
        webResourceSet.writeHtmlTags(writer, UrlModeUtils.convert(urlMode));
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode) {
        this.includeResources(writer, urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode, WebResourceFilter webResourceFilter) {
        this.writeIncludedResources(writer, urlMode, webResourceFilter);
        this.clear();
    }

    @Override
    public String getRequiredResources(UrlMode urlMode) {
        return this.getRequiredResources(urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public String getRequiredResources(UrlMode urlMode, WebResourceFilter filter) {
        return this.writeIncludedResources(new StringWriter(), urlMode, filter).toString();
    }

    protected String getRequiredResources(UrlMode urlMode, WebResourceFilter webResourceFilter, Set<String> excludedResourceKeys, List<String> excludedContexts) {
        return this.writeIncludedResources(new StringWriter(), urlMode, webResourceFilter, excludedResourceKeys, excludedContexts).toString();
    }

    private <W extends Writer> W writeIncludedResources(W writer, UrlMode urlMode, WebResourceFilter filter) {
        return this.writeIncludedResources(writer, urlMode, filter, Collections.<String>emptySet(), Collections.<String>emptyList());
    }

    private <W extends Writer> W writeIncludedResources(W writer, UrlMode urlMode, final WebResourceFilter filter, Set<String> excludedResourceKeys, List<String> excludedContexts) {
        if (null != excludedResourceKeys && !excludedResourceKeys.isEmpty() && null != excludedContexts && !excludedContexts.isEmpty()) {
            this.getRequestLocalRequiredResources().exclude(excludedResourceKeys, (Set)Sets.newHashSet(excludedContexts));
        }
        DefaultWebResourceSet webResourceSet = (DefaultWebResourceSet)this.getRequestLocalAssembledResources().peek();
        webResourceSet.writeHtmlTags(writer, UrlModeUtils.convert(urlMode), (Predicate<WebResource>)Predicates.alwaysTrue(), new Predicate<PluginResource>(){

            public boolean apply(@Nullable PluginResource input) {
                return filter.matches(input.getResourceName());
            }
        });
        return writer;
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer, UrlMode urlMode) {
        WebResourceAssembler webResourceAssembler = this.createSuperbatchingDisabledWebResourceAssembler();
        webResourceAssembler.resources().requireWebResource(moduleCompleteKey);
        WebResourceSet webResourceSet = webResourceAssembler.assembled().drainIncludedResources();
        webResourceSet.writeHtmlTags(writer, UrlModeUtils.convert(urlMode));
    }

    @Override
    public String getResourceTags(String moduleCompleteKey, UrlMode urlMode) {
        StringWriter writer = new StringWriter();
        this.requireResource(moduleCompleteKey, writer, urlMode);
        return writer.toString();
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(resourceCounter, urlMode);
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleCompleteKey, resourceName, urlMode);
    }

    @Override
    public String getStaticPluginResource(ModuleDescriptor<?> moduleDescriptor, String resourceName, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleDescriptor, resourceName, urlMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeInNewContext(Supplier<T> nestedExecution) {
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        ImmutableMap storedState = ImmutableMap.copyOf(cache);
        cache.clear();
        try {
            Object object = nestedExecution.get();
            return (T)object;
        }
        finally {
            cache.clear();
            cache.putAll((Map<String, Object>)storedState);
        }
    }

    protected AssembledResources getRequestLocalAssembledResources() {
        return this.pageBuilderService.assembler().assembled();
    }

    protected RequiredResources getRequestLocalRequiredResources() {
        return this.pageBuilderService.assembler().resources();
    }

    private void clear() {
        this.pageBuilderService.clearRequestLocal();
    }

    @Override
    @Deprecated
    public String getRequiredResources() {
        return this.getRequiredResources(UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getResourceTags(String moduleCompleteKey) {
        return this.getResourceTags(moduleCompleteKey, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticPluginResource(ModuleDescriptor<?> moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName) {
        return this.getStaticPluginResource(moduleCompleteKey, resourceName, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticPluginResourcePrefix(ModuleDescriptor<?> moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticResourcePrefix() {
        return this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticResourcePrefix(UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(urlMode);
    }

    @Override
    @Deprecated
    public String getStaticResourcePrefix(String resourceCounter) {
        return this.getStaticResourcePrefix(resourceCounter, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public void includeResources(Writer writer) {
        this.includeResources(writer, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public void requireResource(String moduleCompleteKey, Writer writer) {
        this.requireResource(moduleCompleteKey, writer, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public void setIncludeMode(WebResourceManager.IncludeMode includeMode) {
        this.webResourceIntegration.getRequestCache().put("plugin.webresource.mode", includeMode);
    }

    private WebResourceAssembler createSuperbatchingDisabledWebResourceAssembler() {
        return this.webResourceAssemblerFactory.create().includeSuperbatchResources(false).build();
    }
}

