/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SinglePluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/resources";
    private final String resourceName;
    private final String moduleCompleteKey;
    private final boolean cached;
    private final Map<String, String> params;

    public SinglePluginResource(String resourceName, String moduleCompleteKey, boolean cached) {
        this(resourceName, moduleCompleteKey, cached, Collections.emptyMap());
    }

    public SinglePluginResource(String resourceName, String moduleCompleteKey, boolean cached, Map<String, String> params) {
        this.resourceName = resourceName;
        this.moduleCompleteKey = moduleCompleteKey;
        this.cached = cached;
        this.params = ImmutableMap.copyOf(params);
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return this.moduleCompleteKey;
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        Plugin plugin = integration.getPluginAccessor().getEnabledPluginModule(this.getModuleCompleteKey()).getPlugin();
        return plugin.getPluginInformation().getVersion();
    }

    @Override
    public boolean isCacheSupported() {
        return this.cached;
    }

    @Override
    public String getUrl() {
        return "/download/resources/" + this.moduleCompleteKey + "/" + this.resourceName;
    }
}

