/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.webresource.BatchPluginResource;
import com.atlassian.plugin.webresource.BatchResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import java.io.OutputStream;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuperBatchPluginResource
implements DownloadableResource,
BatchResource,
PluginResource {
    static final String URL_PREFIX = "/download/superbatch/";
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "batch";
    private final BatchPluginResource delegate;
    private final String resourceName;

    public static boolean matches(String path) {
        String type = SuperBatchPluginResource.getType(path);
        return path.indexOf(URL_PREFIX) != -1 && path.endsWith("batch." + type);
    }

    public static SuperBatchPluginResource createBatchFor(PluginResource pluginResource) {
        return new SuperBatchPluginResource(SuperBatchPluginResource.getType(pluginResource.getResourceName()), pluginResource.getParams());
    }

    public static SuperBatchPluginResource parse(String path, Map<String, String> params) {
        String type = path.substring(path.lastIndexOf(".") + 1);
        return new SuperBatchPluginResource(type, params);
    }

    protected static String getType(String path) {
        int index = path.lastIndexOf(46);
        if (index > -1 && index < path.length()) {
            return path.substring(index + 1);
        }
        return "";
    }

    public SuperBatchPluginResource(String type, Map<String, String> params) {
        this("batch." + type, type, params);
    }

    protected SuperBatchPluginResource(String resourceName, String type, Map<String, String> params) {
        this.resourceName = resourceName;
        this.delegate = new BatchPluginResource(null, type, params);
    }

    @Override
    public boolean isResourceModified(HttpServletRequest request, HttpServletResponse response) {
        return this.delegate.isResourceModified(request, response);
    }

    @Override
    public void serveResource(HttpServletRequest request, HttpServletResponse response) throws DownloadException {
        this.delegate.serveResource(request, response);
    }

    @Override
    public void streamResource(OutputStream out) throws DownloadException {
        this.delegate.streamResource(out);
    }

    @Override
    public String getContentType() {
        return this.delegate.getContentType();
    }

    public void add(DownloadableResource downloadableResource) {
        this.delegate.add(downloadableResource);
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(URL_PREFIX.length() + 20);
        buf.append(URL_PREFIX).append(this.getType()).append("/").append(this.resourceName);
        this.delegate.addParamsToUrl(buf, this.delegate.getParams());
        return buf.toString();
    }

    @Override
    public Map<String, String> getParams() {
        return this.delegate.getParams();
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return integration.getSuperBatchVersion();
    }

    @Override
    public String getType() {
        return this.delegate.getType();
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    @Override
    public String getModuleCompleteKey() {
        return "superbatch";
    }

    public String toString() {
        return "[Superbatch name=" + this.resourceName + ", type=" + this.getType() + ", params=" + this.getParams() + "]";
    }
}

