/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource.cache;

import com.atlassian.plugin.cache.filecache.FileCache;
import com.atlassian.plugin.cache.filecache.FileCacheStreamProvider;
import com.atlassian.plugin.servlet.DownloadException;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.cache.FileCacheKey;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;

public interface CacheHandle {
    public void stream(OutputStream var1, FileCacheStreamProvider var2) throws DownloadException;

    public static class Builder {
        public static CacheHandle passthrough() {
            return new CacheHandle(){

                @Override
                public void stream(OutputStream out, FileCacheStreamProvider streamProvider) throws DownloadException {
                    streamProvider.writeStream(out);
                }
            };
        }

        public static CacheHandle forRequest(final FileCache<FileCacheKey> cache, String downloadtype, String path, Map<String, String> params) {
            if (!ResourceUtils.canRequestedResourcesContentBeAssumedConstant(params)) {
                return Builder.passthrough();
            }
            final FileCacheKey cacheKey = new FileCacheKey(new TreeMap<String, String>(params), downloadtype, path);
            return new CacheHandle(){

                @Override
                public void stream(OutputStream out, FileCacheStreamProvider streamProvider) throws DownloadException {
                    cache.stream(cacheKey, out, streamProvider);
                }
            };
        }
    }
}

