package com.atlassian.plugin.webresource;

import com.atlassian.plugin.util.PluginUtils;

import java.util.List;
import java.util.Collections;

/**
 * Default configuration for the plugin resource locator, for those applications that do not want to perform
 * any super-batching.
 */
public class DefaultResourceBatchingConfiguration implements ResourceBatchingConfiguration
{
    public static final String PLUGIN_WEBRESOURCE_BATCHING_OFF = "plugin.webresource.batching.off";
    public static final String PLUGIN_WEBRESOURCE_TRY_CATCH_WRAPPING = "plugin.webresource.trycatch.wrapping";
    public static final String PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING = "plugin.webresource.batch.content.tracking";

    public boolean isSuperBatchingEnabled()
    {
        return false;
    }

    public List<String> getSuperBatchModuleCompleteKeys()
    {
        return Collections.emptyList();
    }

    public boolean isContextBatchingEnabled()
    {
        return false;
    }

    public boolean isPluginWebResourceBatchingEnabled()
    {
        final String explicitSetting = System.getProperty(PLUGIN_WEBRESOURCE_BATCHING_OFF);
        if (explicitSetting != null)
        {
            return !Boolean.parseBoolean(explicitSetting);
        }
        else
        {
            return !Boolean.parseBoolean(System.getProperty(PluginUtils.ATLASSIAN_DEV_MODE));
        }
    }

    @Override
    public boolean isBatchContentTrackingEnabled()
    {
        final String trackingSetting = System.getProperty(PLUGIN_WEB_RESOURCE_BATCH_CONTENT_TRACKING);
        if (trackingSetting != null)
        {
            return Boolean.parseBoolean(trackingSetting);
        }
        else
        {
            return false;
        }
    }
}
