package com.atlassian.plugin.webresource;

import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * Encapsulate the module complete key and version number string of the host plugin for a WebResource.
 * 
 * @since 2.12.5
 */
class BatchedWebResourceDescriptor
{
    private final String pluginVersion;
    private final String completeKey;
    
    public BatchedWebResourceDescriptor(String pluginVersion, String completeKey)
    {
        this.pluginVersion = pluginVersion;
        this.completeKey = completeKey;
    }

    public String getPluginVersion()
    {
        return pluginVersion;
    }

    public String getCompleteKey()
    {
        return completeKey;
    }

    @Override
    public boolean equals(Object obj)
    {
        if (obj == null)
            return false;

        if (obj == this)
            return true;

        if (!(obj instanceof BatchedWebResourceDescriptor))
            return false;

        BatchedWebResourceDescriptor rhs = (BatchedWebResourceDescriptor) obj;
        
        return new EqualsBuilder().append(completeKey, rhs.completeKey).append(pluginVersion, rhs.pluginVersion).isEquals();
    }
    
    @Override
    public int hashCode()
    {
        return new HashCodeBuilder(71, 11).append(completeKey).append(pluginVersion).toHashCode();
    }

    @Override
    public String toString()
    {
        return new ToStringBuilder(this).append(completeKey).append(pluginVersion).toString();
    }
}
