/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.webresource.BatchedWebResourceDescriptor;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.ResourceKey;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.google.common.collect.ImmutableMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SuperBatchPluginResource
implements PluginResource {
    static final String URL_PREFIX = "/download/superbatch/";
    static final String DEFAULT_RESOURCE_NAME_PREFIX = "batch";
    private final ResourceKey resource;
    private final Map<String, String> params;
    private final Set<BatchedWebResourceDescriptor> batchedWebResourceDescriptors;

    public static SuperBatchPluginResource createBatchFor(PluginResource pluginResource) {
        return new SuperBatchPluginResource(pluginResource.getType(), pluginResource.getParams());
    }

    public SuperBatchPluginResource(String type, Map<String, String> params) {
        this(ResourceKey.Builder.batch(type), params);
    }

    protected SuperBatchPluginResource(ResourceKey resource, Map<String, String> params) {
        this.resource = resource;
        this.params = ImmutableMap.copyOf(params);
        this.batchedWebResourceDescriptors = new HashSet<BatchedWebResourceDescriptor>();
    }

    @Override
    public String getUrl() {
        StringBuilder buf = new StringBuilder(URL_PREFIX.length() + 20);
        buf.append(URL_PREFIX).append(this.getType()).append("/").append(this.getResourceName());
        ResourceUtils.addParamsToUrl(buf, this.getParams());
        return buf.toString();
    }

    @Override
    public Map<String, String> getParams() {
        return this.params;
    }

    @Override
    public String getVersion(WebResourceIntegration integration) {
        return integration.getSuperBatchVersion();
    }

    @Override
    public String getType() {
        return this.resource.suffix();
    }

    @Override
    public boolean isCacheSupported() {
        return true;
    }

    @Override
    public String getResourceName() {
        return this.resource.name();
    }

    @Override
    public String getModuleCompleteKey() {
        return "superbatch";
    }

    void addBatchedWebResourceDescriptor(BatchedWebResourceDescriptor descriptor) {
        this.batchedWebResourceDescriptors.add(descriptor);
    }

    @Override
    public Set<BatchedWebResourceDescriptor> getBatchedWebResourceDescriptors() {
        return this.batchedWebResourceDescriptors;
    }

    public String toString() {
        return "[Superbatch type=" + this.getType() + ", params=" + this.getParams() + "]";
    }
}

