/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.util.concurrent.NotNull;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceUtils {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtils.class);
    public static final String STATIC_HASH = new String("_statichash");

    public static String getType(@NotNull String path) {
        int index = path.lastIndexOf(46);
        if (index > -1 && index < path.length()) {
            return path.substring(index + 1);
        }
        return "";
    }

    public static void addParamsToUrl(StringBuilder sb, Map<String, String> params) {
        if (params.size() > 0) {
            sb.append("?");
            int count = 0;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                try {
                    sb.append(URLEncoder.encode(entry.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                    if (++count >= params.size()) continue;
                    sb.append("&");
                }
                catch (UnsupportedEncodingException e) {
                    log.error("Could not encode parameter to url for [" + entry.getKey() + "] with value [" + entry.getValue() + "]", (Throwable)e);
                }
            }
        }
    }

    public static Map<String, String> getQueryParameters(HttpServletRequest request) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        Map parameters = request.getParameterMap();
        for (Map.Entry entry : parameters.entrySet()) {
            if (entry.getValue() == null || ((String[])entry.getValue()).length <= 0) continue;
            result.put((String)entry.getKey(), ((String[])entry.getValue())[0]);
        }
        String hash = (String)request.getAttribute(STATIC_HASH);
        if (hash != null) {
            result.put(STATIC_HASH, hash);
        }
        return result;
    }

    public static boolean canRequestedResourcesContentBeAssumedConstant(Map<String, String> params) {
        boolean nocache = "false".equals(params.get("cache"));
        boolean nohash = !params.containsKey(STATIC_HASH);
        return !nohash && !nocache;
    }
}

