/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.servlet.DownloadableResource;
import com.atlassian.plugin.util.EfficientStringUtils;
import com.atlassian.plugin.webresource.AbstractBatchResourceBuilder;
import com.atlassian.plugin.webresource.ContextBatchPluginResource;
import com.atlassian.plugin.webresource.DownloadableResourceFinder;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.ResourceUtils;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ContextBatchDownloadableResourceBuilder
extends AbstractBatchResourceBuilder {
    private static final Logger log = LoggerFactory.getLogger(ContextBatchDownloadableResourceBuilder.class);
    private final ResourceDependencyResolver dependencyResolver;

    ContextBatchDownloadableResourceBuilder(ResourceDependencyResolver dependencyResolver, PluginAccessor pluginAccessor, WebResourceUrlProvider webResourceUrlProvider, DownloadableResourceFinder resourceFinder) {
        super(pluginAccessor, webResourceUrlProvider, resourceFinder);
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public boolean matches(String path) {
        String type = ResourceUtils.getType(path);
        return path.indexOf("/download/contextbatch/" + type) > -1 && EfficientStringUtils.endsWith((String)path, (String[])new String[]{"batch", ".", type});
    }

    @Override
    public ContextBatchPluginResource parse(String path, Map<String, String> params) {
        String type = ResourceUtils.getType(path);
        String key = this.getKey(path);
        List<String> contexts = this.getContexts(key);
        HashSet alreadyIncluded = Sets.newHashSet();
        Object resources = ImmutableList.of();
        for (String context : contexts) {
            for (WebResourceModuleDescriptor moduleDescriptor : this.dependencyResolver.getDependenciesInContext(context)) {
                String moduleKey = moduleDescriptor.getCompleteKey();
                if (alreadyIncluded.contains(moduleKey)) continue;
                resources = Iterables.concat((Iterable)resources, this.resolve((ModuleDescriptor<?>)moduleDescriptor, type, params));
                alreadyIncluded.add(moduleKey);
            }
        }
        return new ContextBatchPluginResource(key, contexts, type, params, (Iterable<DownloadableResource>)resources);
    }

    private String getKey(String path) {
        int secondSlashIndex = path.lastIndexOf("/");
        int firstSlashIndex = path.lastIndexOf("/", secondSlashIndex - 1);
        return path.substring(firstSlashIndex + 1, secondSlashIndex);
    }

    private List<String> getContexts(String key) {
        return Arrays.asList(key.split(","));
    }
}

