/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.webresource;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugin.webresource.ContextBatchBuilder;
import com.atlassian.plugin.webresource.CssWebResource;
import com.atlassian.plugin.webresource.DefaultResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.DefaultResourceDependencyResolver;
import com.atlassian.plugin.webresource.DefaultWebResourceFilter;
import com.atlassian.plugin.webresource.JavascriptWebResource;
import com.atlassian.plugin.webresource.PluginResource;
import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.ResourceBatchingConfiguration;
import com.atlassian.plugin.webresource.ResourceDependencyResolver;
import com.atlassian.plugin.webresource.SuperBatchPluginResource;
import com.atlassian.plugin.webresource.TransformDescriptorToKey;
import com.atlassian.plugin.webresource.UrlMode;
import com.atlassian.plugin.webresource.WebResourceFilter;
import com.atlassian.plugin.webresource.WebResourceFormatter;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.plugin.webresource.WebResourceModuleDescriptor;
import com.atlassian.plugin.webresource.WebResourceUrlProvider;
import com.google.common.base.Function;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WebResourceManagerImpl
implements WebResourceManager {
    static final String STATIC_RESOURCE_PREFIX = "s";
    static final String STATIC_RESOURCE_SUFFIX = "_";
    static final String REQUEST_CACHE_RESOURCE_KEY = "plugin.webresource.names";
    static final String REQUEST_CACHE_CONTEXT_KEY = "plugin.webresource.contexts";
    protected final WebResourceIntegration webResourceIntegration;
    protected final PluginResourceLocator pluginResourceLocator;
    private final WebResourceUrlProvider webResourceUrlProvider;
    protected final ResourceBatchingConfiguration batchingConfiguration;
    protected final ResourceDependencyResolver dependencyResolver;
    protected static final List<WebResourceFormatter> webResourceFormatters = Arrays.asList(CssWebResource.FORMATTER, JavascriptWebResource.FORMATTER);
    private static final boolean IGNORE_SUPERBATCHING = false;

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider) {
        this(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, new DefaultResourceBatchingConfiguration());
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration) {
        this(pluginResourceLocator, webResourceIntegration, webResourceUrlProvider, batchingConfiguration, new DefaultResourceDependencyResolver(webResourceIntegration, batchingConfiguration));
    }

    public WebResourceManagerImpl(PluginResourceLocator pluginResourceLocator, WebResourceIntegration webResourceIntegration, WebResourceUrlProvider webResourceUrlProvider, ResourceBatchingConfiguration batchingConfiguration, ResourceDependencyResolver dependencyResolver) {
        this.pluginResourceLocator = (PluginResourceLocator)Assertions.notNull((String)"pluginResourceLocator", (Object)pluginResourceLocator);
        this.webResourceIntegration = (WebResourceIntegration)Assertions.notNull((String)"webResourceIntegration", (Object)webResourceIntegration);
        this.webResourceUrlProvider = (WebResourceUrlProvider)Assertions.notNull((String)"webResourceUrlProvider", (Object)webResourceUrlProvider);
        this.batchingConfiguration = (ResourceBatchingConfiguration)Assertions.notNull((String)"batchingConfiguration", (Object)batchingConfiguration);
        this.dependencyResolver = (ResourceDependencyResolver)Assertions.notNull((String)"dependencyResolver", (Object)dependencyResolver);
    }

    @Override
    public void requireResource(String moduleCompleteKey) {
        boolean batchingEnabled = this.batchingConfiguration.isSuperBatchingEnabled();
        Iterables.addAll(this.getIncludedResourceNames(), this.toModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, batchingEnabled)));
    }

    @Override
    public void requireResourcesForContext(String context) {
        this.getIncludedContexts().add(context);
    }

    @Override
    public void includeResources(Iterable<String> moduleCompleteKeys, Writer writer, UrlMode urlMode) {
        Iterable resources = Lists.newArrayList();
        for (String moduleCompleteKey : moduleCompleteKeys) {
            Iterable<String> dependencies = this.toModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, false));
            resources = Iterables.concat((Iterable)resources, dependencies);
        }
        resources = ImmutableSet.copyOf((Iterable)resources);
        this.writeResourceTags(this.getModuleResources(resources, Collections.<String>emptyList(), DefaultWebResourceFilter.INSTANCE), writer, urlMode);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode) {
        this.includeResources(writer, urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public void includeResources(Writer writer, UrlMode urlMode, WebResourceFilter webResourceFilter) {
        this.writeIncludedResources(writer, urlMode, webResourceFilter);
        this.clear();
    }

    @Override
    public String getRequiredResources(UrlMode urlMode) {
        return this.getRequiredResources(urlMode, DefaultWebResourceFilter.INSTANCE);
    }

    @Override
    public String getRequiredResources(UrlMode urlMode, WebResourceFilter filter) {
        return this.writeIncludedResources(new StringWriter(), urlMode, filter).toString();
    }

    private <W extends Writer> W writeIncludedResources(W writer, UrlMode urlMode, WebResourceFilter filter) {
        ContextBatchBuilder builder = new ContextBatchBuilder(this.pluginResourceLocator, this.dependencyResolver, this.batchingConfiguration);
        Iterable resourcesToInclude = Iterables.concat(this.getSuperBatchResources(filter), builder.build(this.getIncludedContexts(), filter));
        for (String skippedResource : builder.getSkippedResources()) {
            this.requireResource(skippedResource);
        }
        Iterable<PluginResource> moduleResources = this.getModuleResources(this.getIncludedResourceNames(), builder.getAllIncludedResources(), filter);
        return this.writeResourceTags(Iterables.concat((Iterable)resourcesToInclude, moduleResources), writer, urlMode);
    }

    List<PluginResource> getSuperBatchResources(WebResourceFilter filter) {
        if (!this.batchingConfiguration.isSuperBatchingEnabled()) {
            return Collections.emptyList();
        }
        Iterable<WebResourceModuleDescriptor> superBatchModuleKeys = this.dependencyResolver.getSuperBatchDependencies();
        ArrayList<PluginResource> resources = new ArrayList<PluginResource>();
        for (WebResourceFormatter formatter : webResourceFormatters) {
            HashSet alreadyIncluded = new HashSet();
            for (WebResourceModuleDescriptor moduleDescriptor : superBatchModuleKeys) {
                for (PluginResource pluginResource : this.pluginResourceLocator.getPluginResources(moduleDescriptor.getCompleteKey())) {
                    if (!formatter.matches(pluginResource.getResourceName()) || !filter.matches(pluginResource.getResourceName())) continue;
                    HashMap<String, String> batchParamsMap = new HashMap<String, String>(PluginResourceLocator.BATCH_PARAMS.length);
                    for (String s : PluginResourceLocator.BATCH_PARAMS) {
                        batchParamsMap.put(s, pluginResource.getParams().get(s));
                    }
                    if (alreadyIncluded.contains(batchParamsMap)) continue;
                    resources.add(SuperBatchPluginResource.createBatchFor(pluginResource));
                    alreadyIncluded.add(batchParamsMap);
                }
            }
        }
        return resources;
    }

    private <W extends Writer> W writeResourceTags(Iterable<PluginResource> resourcesToInclude, W writer, UrlMode urlMode) {
        for (WebResourceFormatter formatter : webResourceFormatters) {
            Iterator<PluginResource> iter = resourcesToInclude.iterator();
            while (iter.hasNext()) {
                PluginResource resource = iter.next();
                if (!formatter.matches(resource.getResourceName())) continue;
                this.writeResourceTag(urlMode, resource, formatter, writer);
                iter.remove();
            }
        }
        for (PluginResource resource : resourcesToInclude) {
            this.writeContentAndSwallowErrors(writer, "<!-- Error loading resource \"", resource.getModuleCompleteKey(), "\".  No resource formatter matches \"", resource.getResourceName(), "\" -->\n");
        }
        return writer;
    }

    private void writeResourceTag(UrlMode urlMode, PluginResource resource, WebResourceFormatter formatter, Writer writer) {
        String prefix = resource.isCacheSupported() ? this.webResourceUrlProvider.getStaticResourcePrefix(resource.getVersion(this.webResourceIntegration), urlMode) : this.webResourceUrlProvider.getBaseUrl(urlMode);
        this.writeContentAndSwallowErrors(writer, formatter.formatResource(prefix + resource.getUrl(), resource.getParams()));
    }

    @Override
    public void requireResource(String moduleCompleteKey, Writer writer, UrlMode urlMode) {
        Iterable<String> allDependentModuleKeys = this.toModuleKeys(this.dependencyResolver.getDependencies(moduleCompleteKey, false));
        List<String> empty = Collections.emptyList();
        Iterable<PluginResource> resourcesToInclude = this.getModuleResources(allDependentModuleKeys, empty, DefaultWebResourceFilter.INSTANCE);
        this.writeResourceTags(resourcesToInclude, writer, urlMode);
    }

    @Override
    public String getResourceTags(String moduleCompleteKey, UrlMode urlMode) {
        StringWriter writer = new StringWriter();
        this.requireResource(moduleCompleteKey, writer, urlMode);
        return writer.toString();
    }

    @Override
    public String getStaticResourcePrefix(String resourceCounter, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(resourceCounter, urlMode);
    }

    @Override
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleCompleteKey, resourceName, urlMode);
    }

    @Override
    public String getStaticPluginResource(ModuleDescriptor<?> moduleDescriptor, String resourceName, UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticPluginResourceUrl(moduleDescriptor, resourceName, urlMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T executeInNewContext(Supplier<T> nestedExecution) {
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        ImmutableMap storedState = ImmutableMap.copyOf(cache);
        cache.clear();
        try {
            Object object = nestedExecution.get();
            return (T)object;
        }
        finally {
            cache.clear();
            cache.putAll((Map<String, Object>)storedState);
        }
    }

    private Iterable<PluginResource> getModuleResources(Iterable<String> webResourcePluginModuleKeys, Iterable<String> batchedModules, WebResourceFilter filter) {
        LinkedList<PluginResource> includedResources = new LinkedList<PluginResource>();
        for (String moduleKey : webResourcePluginModuleKeys) {
            if (Iterables.contains(batchedModules, (Object)moduleKey)) continue;
            List<PluginResource> moduleResources = this.pluginResourceLocator.getPluginResources(moduleKey);
            for (PluginResource moduleResource : moduleResources) {
                if (!filter.matches(moduleResource.getResourceName())) continue;
                includedResources.add(moduleResource);
            }
        }
        return includedResources;
    }

    private void writeContentAndSwallowErrors(Writer writer, String ... contents) {
        try {
            for (String content : contents) {
                writer.write(content);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Set<String> getIncludedContexts() {
        return this.getOrCreateFromRequestCache(REQUEST_CACHE_CONTEXT_KEY);
    }

    private Set<String> getIncludedResourceNames() {
        return this.getOrCreateFromRequestCache(REQUEST_CACHE_RESOURCE_KEY);
    }

    private Set<String> getOrCreateFromRequestCache(String key) {
        Map<String, Object> cache = this.webResourceIntegration.getRequestCache();
        Set set = (Set)cache.get(key);
        if (set == null) {
            set = Sets.newLinkedHashSet();
            cache.put(key, set);
        }
        return set;
    }

    private void clear() {
        this.getIncludedResourceNames().clear();
        this.getIncludedContexts().clear();
    }

    private Iterable<String> toModuleKeys(Iterable<WebResourceModuleDescriptor> descriptors) {
        return Iterables.transform(descriptors, (Function)new TransformDescriptorToKey());
    }

    @Override
    @Deprecated
    public String getRequiredResources() {
        return this.getRequiredResources(UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getResourceTags(String moduleCompleteKey) {
        return this.getResourceTags(moduleCompleteKey, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticPluginResource(ModuleDescriptor<?> moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticPluginResource(String moduleCompleteKey, String resourceName) {
        return this.getStaticPluginResource(moduleCompleteKey, resourceName, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticPluginResourcePrefix(ModuleDescriptor<?> moduleDescriptor, String resourceName) {
        return this.getStaticPluginResource(moduleDescriptor, resourceName, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticResourcePrefix() {
        return this.webResourceUrlProvider.getStaticResourcePrefix(UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public String getStaticResourcePrefix(UrlMode urlMode) {
        return this.webResourceUrlProvider.getStaticResourcePrefix(urlMode);
    }

    @Override
    @Deprecated
    public String getStaticResourcePrefix(String resourceCounter) {
        return this.getStaticResourcePrefix(resourceCounter, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public void includeResources(Writer writer) {
        this.includeResources(writer, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public void requireResource(String moduleCompleteKey, Writer writer) {
        this.requireResource(moduleCompleteKey, writer, UrlMode.AUTO);
    }

    @Override
    @Deprecated
    public void setIncludeMode(WebResourceManager.IncludeMode includeMode) {
        this.webResourceIntegration.getRequestCache().put("plugin.webresource.mode", includeMode);
    }
}

