/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collection;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    public static void write2File(byte[] content, File file) throws IOException {
        Files.write(file.toPath(), content, new OpenOption[0]);
    }

    public static void zipFiles(File directory, Collection<String> sources, File destination) throws IOException {
        try (FileOutputStream dest = new FileOutputStream(destination);
             CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
             ZipOutputStream out = new ZipOutputStream(new BufferedOutputStream(checksum));){
            for (String source : sources) {
                log.trace("Adding: {}", (Object)source);
                FileInputStream fi = new FileInputStream(source);
                Throwable throwable = null;
                try {
                    BufferedInputStream origin = new BufferedInputStream(fi);
                    Throwable throwable2 = null;
                    try {
                        ZipEntry entry = new ZipEntry(source.replaceFirst(directory.getPath(), ""));
                        out.putNextEntry(entry);
                        IOUtils.copy((InputStream)origin, (OutputStream)out);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (origin == null) continue;
                        if (throwable2 != null) {
                            try {
                                origin.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        origin.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (fi == null) continue;
                    if (throwable != null) {
                        try {
                            fi.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    fi.close();
                }
            }
        }
    }
}

