/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.cdn.mapper.DefaultMapping;
import com.atlassian.plugin.webresource.cdn.mapper.DefaultMappingSet;
import com.atlassian.plugin.webresource.cdn.mapper.MappingParser;
import com.atlassian.plugin.webresource.cdn.mapper.MappingSet;
import com.atlassian.plugin.webresource.impl.PrebakeErrorFactory;
import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.atlassian.webresource.plugin.prebake.discovery.Bundler;
import com.atlassian.webresource.plugin.prebake.discovery.TaintedResource;
import com.atlassian.webresource.plugin.prebake.exception.PreBakeIOException;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import com.atlassian.webresource.plugin.prebake.resources.ResourceContent;
import com.atlassian.webresource.plugin.prebake.util.FileUtil;
import com.atlassian.webresource.plugin.prebake.util.PreBakeUtil;
import com.atlassian.webresource.plugin.prebake.util.StopWatch;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ZipBundler
implements Bundler {
    private static final Logger log = LoggerFactory.getLogger(ZipBundler.class);
    private static final DecimalFormat PERCENT_FORMAT = new DecimalFormat("#0.00");
    private static final MappingParser mappingParser = new MappingParser();
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile boolean zipCreated = false;
    private final String globalStateHash;
    private final Path outputFolder;
    private final Path bundleDir;
    private final Path bundleZip;
    private final Path tempResourcesDir;
    private final boolean checkHashCollisions;
    private final Map<String, String> mappings = new HashMap<String, String>();
    private final Map<String, TaintedResource> tainted = new HashMap<String, TaintedResource>();

    public ZipBundler(String globalStateHash, Path outputFolder) {
        this(globalStateHash, outputFolder, false);
    }

    public ZipBundler(String globalStateHash, Path outputFolder, boolean checkHashCollisions) {
        this.globalStateHash = globalStateHash;
        this.outputFolder = outputFolder;
        this.bundleDir = outputFolder.resolve(PreBakeUtil.BUNDLE_ZIP_DIR);
        this.bundleZip = outputFolder.resolve("bundle.zip");
        this.tempResourcesDir = this.bundleDir.resolve(PreBakeUtil.RELATIVE_RESOURCES);
        boolean created = this.tempResourcesDir.toFile().mkdirs();
        if (!created) {
            String msg = String.format("Could not create temporary resource folder '%s'", this.tempResourcesDir.toString());
            throw new PreBakeIOException(msg);
        }
        this.checkHashCollisions = checkHashCollisions;
    }

    public String getGlobalStateHash() {
        return this.globalStateHash;
    }

    public Path getBundleZipPath() {
        return this.bundleZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<String> addResource(String url, Resource resource, ResourceContent content) {
        if (this.zipCreated) {
            throw new IllegalStateException("Cannot add more resources after bundle.zip creation");
        }
        if (resource.isTainted()) {
            throw new IllegalArgumentException("Cannot add tainted resource '" + url + "'");
        }
        this.lock.writeLock().lock();
        try {
            if (this.mappings.containsKey(url)) {
                Optional<String> optional = Optional.of(this.mappings.get(url));
                return optional;
            }
            Optional<String> optional = this.saveResource(url, resource, content);
            return optional;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private Optional<String> saveResource(String url, Resource resource, ResourceContent content) {
        byte[] bytes = content.getContent();
        String hashedFilename = PreBakeUtil.hash(bytes) + resource.getExtension();
        String hashedUrl = "/" + hashedFilename;
        Path target = this.tempResourcesDir.resolve(hashedFilename);
        try {
            if (!Files.exists(target, new LinkOption[0])) {
                this.saveContent(target, bytes);
                this.mappings.put(url, hashedUrl);
                return Optional.of(hashedUrl);
            }
            if (this.checkHashCollisions && this.contentIsDifferent(target, bytes)) {
                String collidedWith = this.getUrlWithHashedFilename(hashedFilename);
                String msg = String.format("Hash collision between '%s' and '%s'", url, collidedWith);
                log.error(msg);
                this.addTaintedResource(url, resource.getName(), PrebakeErrorFactory.from((String)msg));
                return Optional.empty();
            }
            this.mappings.put(url, hashedUrl);
            return Optional.of(hashedFilename);
        }
        catch (IOException e) {
            String msg = "Cannot save resource content to " + target.toAbsolutePath();
            log.error(msg, (Throwable)e);
            this.addTaintedResource(url, resource.getName(), PrebakeErrorFactory.from((String)msg, (Throwable)e));
            return Optional.empty();
        }
    }

    private void saveContent(Path target, byte[] bytes) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(bytes);
        Files.copy(is, target, new CopyOption[0]);
        ((InputStream)is).close();
    }

    private boolean contentIsDifferent(Path target, byte[] bytes) throws IOException {
        try {
            byte[] existing = Files.readAllBytes(target);
            return !Arrays.equals(bytes, existing);
        }
        catch (IOException e) {
            throw new IOException("Error comparing resource content while checking hash collision", e);
        }
    }

    private String getUrlWithHashedFilename(String hashedFilename) {
        return this.mappings.entrySet().stream().filter(e -> ((String)e.getValue()).equals(hashedFilename)).map(Map.Entry::getKey).findFirst().get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaintedResource(String url, Resource resource) {
        if (this.zipCreated) {
            throw new IllegalStateException("Cannot add more tainted resources after bundle.zip creation");
        }
        if (!resource.isTainted()) {
            return;
        }
        this.lock.writeLock().lock();
        try {
            if (this.tainted.containsKey(url)) {
                return;
            }
            TaintedResource tr = new TaintedResource(resource.getUrl(), resource.getName(), resource.getPrebakeErrors());
            this.tainted.put(url, tr);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTaintedResource(String url, String name, PrebakeError ... errors) {
        if (this.zipCreated) {
            throw new IllegalStateException("Cannot add more tainted resources after bundle.zip creation");
        }
        this.lock.writeLock().lock();
        try {
            if (this.tainted.containsKey(url)) {
                return;
            }
            TaintedResource tr = new TaintedResource(url, name, Arrays.asList(errors));
            this.tainted.put(url, tr);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    public boolean isMapped(String url) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.mappings.containsKey(url);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public boolean isTainted(String url) {
        this.lock.readLock().lock();
        try {
            boolean bl = this.tainted.containsKey(url);
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getMappedCount() {
        this.lock.readLock().lock();
        try {
            int n = this.mappings.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public Optional<String> getMapping(String url) {
        this.lock.readLock().lock();
        try {
            Optional<String> optional = Optional.ofNullable(this.mappings.get(url));
            return optional;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public int getTaintedCount() {
        this.lock.readLock().lock();
        try {
            int n = this.tainted.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void createBundleZip() throws PreBakeIOException {
        this.lock.writeLock().lock();
        try {
            if (this.zipCreated) {
                log.info("Skipping, bundle.zip has already been created.");
                return;
            }
            this.zipCreated = true;
            StopWatch stopwatch = new StopWatch();
            this.doCreateBundleZip();
            log.info("bundle.zip creation took " + stopwatch.getElapsedSecondsAndReset() + "s");
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    private void doCreateBundleZip() throws PreBakeIOException {
        ArrayList<String> sources = new ArrayList<String>();
        try {
            File globalStateHashFile = this.bundleDir.resolve("state.txt").toFile();
            FileUtil.write2File(this.globalStateHash.getBytes("UTF-8"), globalStateHashFile);
            sources.add(globalStateHashFile.getAbsolutePath());
            File mappingsFile = this.bundleDir.resolve("mappings.json").toFile();
            FileUtil.write2File(this.getMappingsAsByteArray(), mappingsFile);
            sources.add(mappingsFile.getAbsolutePath());
            File prebakeReportFile = this.bundleDir.resolve("report.txt").toFile();
            this.writeBatchReport(prebakeReportFile);
            sources.add(prebakeReportFile.getAbsolutePath());
            sources.addAll(this.getPrebakedFileSet());
            FileUtil.zipFiles(this.outputFolder.toFile(), sources, this.bundleZip.toFile());
        }
        catch (IOException e) {
            String msg = String.format("Cannot create '%s'", this.bundleZip.toString());
            log.error(msg, (Throwable)e);
            throw new PreBakeIOException(msg, e);
        }
    }

    private byte[] getMappingsAsByteArray() throws IOException {
        HashSet<DefaultMapping> ms = new HashSet<DefaultMapping>();
        for (Map.Entry<String, String> e : this.mappings.entrySet()) {
            DefaultMapping m = new DefaultMapping(e.getKey(), Collections.singletonList(e.getValue()).stream());
            ms.add(m);
        }
        DefaultMappingSet mappingSet = new DefaultMappingSet(ms);
        return mappingParser.getAsString((MappingSet)mappingSet).getBytes("UTF-8");
    }

    private Set<String> getPrebakedFileSet() {
        return StreamSupport.stream(this.mappings.values().spliterator(), false).map(url -> url.substring(1)).map(this.tempResourcesDir::resolve).map(Path::toString).sorted().collect(Collectors.toSet());
    }

    private void writeBatchReport(File reportFile) throws IOException {
        int taintCount;
        FileWriter fw = new FileWriter(reportFile);
        BufferedWriter bw = new BufferedWriter(fw);
        int mapCount = this.mappings.size();
        int total = mapCount + (taintCount = this.tainted.size());
        double coverage = total == 0 ? 0.0 : (double)mapCount / (double)total * 100.0;
        bw.append("Coverage: ").append(PERCENT_FORMAT.format(coverage)).append("%\n");
        bw.append("Baked resources: ").append(String.valueOf(mapCount)).append("\n");
        bw.append("Tainted resources: ").append(String.valueOf(taintCount)).append("\n");
        for (TaintedResource tr : this.tainted.values()) {
            bw.append("\nRESOURCE: ");
            bw.append(tr.getUrl());
            bw.append("\n");
            List<PrebakeError> pes = tr.getPrebakeErrors();
            for (int i = 0; i < pes.size(); ++i) {
                PrebakeError pe = pes.get(i);
                bw.append(String.valueOf(i)).append(") ");
                bw.append(pe.toString());
                bw.append("\n");
            }
        }
        bw.close();
        fw.close();
    }
}

