/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.plugin.webresource.impl.PrebakeErrorFactory;
import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.atlassian.webresource.api.assembler.resource.PrebakeWarning;
import com.atlassian.webresource.plugin.prebake.discovery.Bundler;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourceCrawler;
import com.atlassian.webresource.plugin.prebake.exception.PreBakeException;
import com.atlassian.webresource.plugin.prebake.exception.PreBakeIOException;
import com.atlassian.webresource.plugin.prebake.resources.GenericUrlResource;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import com.atlassian.webresource.plugin.prebake.resources.ResourceCollector;
import com.atlassian.webresource.plugin.prebake.resources.ResourceContent;
import com.atlassian.webresource.plugin.prebake.util.StopWatch;
import com.google.common.base.Preconditions;
import io.atlassian.util.concurrent.ThreadFactories;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DiscoveryTask {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryTask.class);
    private static final int MAX_RESOURCE_QUEUE_LENGTH = 2048;
    private static final int MAX_THREADS = 2;
    private static final ExecutorService pool = Executors.newFixedThreadPool(2, ThreadFactories.namedThreadFactory((String)"prebaker-collection", (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    private final List<WebResourceCrawler> crawlers;
    private final ResourceCollector resourceCollector;
    private final Bundler bundler;
    private final String contextPath;
    private final String baseUrl;
    private final Pattern cssUrlPattern;
    private final boolean ignorePrebakeWarnings;
    private final boolean isCSSPrebakingEnabled;

    public DiscoveryTask(boolean ignorePrebakeWarnings, boolean isCSSPrebakingEnabled, String contextPath, String baseUrl, List<WebResourceCrawler> crawlers, ResourceCollector resourceCollector, Bundler bundler) {
        Preconditions.checkArgument((!CollectionUtils.isEmpty(crawlers) ? 1 : 0) != 0);
        this.ignorePrebakeWarnings = ignorePrebakeWarnings;
        this.isCSSPrebakingEnabled = isCSSPrebakingEnabled;
        this.contextPath = contextPath;
        this.baseUrl = baseUrl;
        this.crawlers = crawlers;
        this.resourceCollector = resourceCollector;
        this.bundler = bundler;
        this.cssUrlPattern = Pattern.compile("url[\\s]*+\\([\\s]*+[\"']?[\\s]*+(?!https?://|data:)" + Pattern.quote(contextPath) + "(?<url>[^\\)\"']*)[\\s]*+[\"']?[\\s]*+\\)");
    }

    public void doRun() throws PreBakeException {
        AtomicBoolean urlFetchingComplete = new AtomicBoolean(false);
        ArrayBlockingQueue queue = new ArrayBlockingQueue(2048);
        StopWatch stopwatch = new StopWatch();
        Future<Void> resourceFetcher = pool.submit(() -> {
            while (!queue.isEmpty() || !urlFetchingComplete.get()) {
                Resource res = (Resource)queue.poll(2L, TimeUnit.SECONDS);
                if (res == null) continue;
                this.collect(res);
            }
            return null;
        });
        pool.submit(() -> {
            try {
                for (WebResourceCrawler c : this.crawlers) {
                    c.crawl(queue);
                }
            }
            catch (InterruptedException e) {
                resourceFetcher.cancel(true);
            }
            finally {
                urlFetchingComplete.set(true);
            }
        });
        try {
            resourceFetcher.get();
            log.info("Resource collection took " + stopwatch.getElapsedSecondsAndReset() + "s");
        }
        catch (Exception e) {
            throw new PreBakeException("Unable to complete prebake", e);
        }
    }

    private Optional<String> collect(Resource res) {
        if (!this.isCSSPrebakingEnabled && res.getExtension().equals(".css")) {
            return Optional.empty();
        }
        String url = res.getUrl();
        String relativeUrl = this.toRelativeUrl(url);
        if (this.bundler.isMapped(relativeUrl)) {
            return this.bundler.getMapping(relativeUrl);
        }
        if (this.bundler.isTainted(relativeUrl)) {
            return Optional.empty();
        }
        if (!this.isSafeForPrebaking(res)) {
            log.warn(String.format("Encountered tainted resource: %s", url));
            this.bundler.addTaintedResource(relativeUrl, res);
            return Optional.empty();
        }
        try {
            URI uri = this.toAbsoluteURI(url);
            ResourceContent content = this.resourceCollector.collect(uri);
            if (res.getExtension().equals(".css")) {
                content = this.processCSS(content);
            }
            return this.bundler.addResource(relativeUrl, res, content);
        }
        catch (Exception e) {
            String msg = String.format("Error processing resource '%s'", url);
            log.warn(msg);
            this.bundler.addTaintedResource(relativeUrl, res.getName(), PrebakeErrorFactory.from((String)msg, (Throwable)e));
            return Optional.empty();
        }
    }

    private boolean isSafeForPrebaking(Resource res) {
        if (!res.isTainted()) {
            return true;
        }
        if (!this.ignorePrebakeWarnings) {
            return false;
        }
        List<PrebakeError> errors = res.getPrebakeErrors();
        if (!this.containsOnlyWarnings(errors)) {
            return false;
        }
        StringBuilder sb = new StringBuilder().append("Ignoring PrebakeWarning on resource ").append(res.getUrl()).append(":");
        for (PrebakeError e : errors) {
            sb.append("\n\t").append(e.toString());
        }
        log.warn(sb.toString());
        return true;
    }

    private boolean containsOnlyWarnings(List<PrebakeError> errors) {
        return !errors.stream().anyMatch(e -> !(e instanceof PrebakeWarning));
    }

    private ResourceContent processCSS(ResourceContent originalCSS) throws PreBakeIOException {
        String input = new String(originalCSS.getContent(), StandardCharsets.UTF_8);
        Matcher matcher = this.cssUrlPattern.matcher(input);
        StringBuffer output = new StringBuffer();
        while (matcher.find()) {
            String cssResourceUrl = matcher.group("url").trim();
            Optional<String> hash = this.collect(new GenericUrlResource(cssResourceUrl));
            String replacement = hash.map(s -> "url(" + s + ")").orElseThrow(() -> new PreBakeIOException(String.format("Cannot prebake CSS file: resource '%s' is missing", cssResourceUrl)));
            matcher.appendReplacement(output, replacement);
        }
        matcher.appendTail(output);
        return new ResourceContent(originalCSS.getUri(), originalCSS.getContentType(), output.toString().getBytes(StandardCharsets.UTF_8));
    }

    private String toRelativeUrl(String uriString) {
        if (uriString.contains(this.baseUrl)) {
            return uriString.replace(this.baseUrl, "");
        }
        return uriString;
    }

    private URI toAbsoluteURI(String uriString) throws URISyntaxException {
        String absoluteUrl = uriString.startsWith(this.baseUrl) ? uriString : (uriString.startsWith(this.contextPath) ? this.baseUrl + uriString.replace(this.contextPath, "") : this.baseUrl + uriString);
        return new URI(absoluteUrl);
    }
}

