/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.rest;

import com.atlassian.plugin.webresource.PluginResourceLocator;
import com.atlassian.plugin.webresource.WebResourceIntegration;
import com.atlassian.plugin.webresource.impl.Globals;
import com.atlassian.plugin.webresource.impl.config.Config;
import com.atlassian.plugin.webresource.prebake.PrebakeWebResourceAssemblerFactory;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.webresource.plugin.prebake.discovery.PreBakeState;
import com.atlassian.webresource.plugin.prebake.discovery.RootPageCrawler;
import com.atlassian.webresource.plugin.prebake.discovery.SuperBatchCrawler;
import com.atlassian.webresource.plugin.prebake.discovery.TaintedResource;
import com.atlassian.webresource.plugin.prebake.discovery.WebResourcePreBaker;
import com.atlassian.webresource.plugin.prebake.resources.HttpResourceCollector;
import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AnonymousAllowed
@Path(value="prebake")
public final class PreBakeResource {
    private static final Logger log = LoggerFactory.getLogger(PreBakeResource.class);
    private final WebResourcePreBaker preBaker;
    private final Config config;
    private final Globals globals;
    @Context
    @VisibleForTesting
    UriInfo info;

    public PreBakeResource(WebResourceIntegration webResourceIntegration, PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory, PluginResourceLocator pluginResourceLocator) {
        this(pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt().getConfig(), pluginResourceLocator.temporaryWayToGetGlobalsDoNotUseIt(), webResourceIntegration, webResourceAssemblerFactory);
    }

    @VisibleForTesting
    PreBakeResource(Config config, Globals globals, WebResourceIntegration webResourceIntegration, PrebakeWebResourceAssemblerFactory webResourceAssemblerFactory) {
        this.globals = globals;
        this.config = config;
        this.preBaker = new WebResourcePreBaker(config, webResourceIntegration, webResourceAssemblerFactory, new HttpResourceCollector());
    }

    @Path(value="/state")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public final Response put(PreBakeResult request) {
        return this.whenPreBakeIsEnabled(() -> {
            this.preBaker.start(new SuperBatchCrawler(this.preBaker.getWebResourceAssemblerFactory()));
            return Response.ok((Object)new PreBakeResult(PreBakeState.RUNNING, "" + URI.create(this.info.getBaseUri() + "/prebake/bundle.zip").normalize(), this.preBaker.getBatch().getVersion(), this.preBaker.getBatch().getTaintedResources())).build();
        });
    }

    @Path(value="/start")
    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public final Response prebakeRootPages(PreBakeResult request) {
        return this.whenPreBakeIsEnabled(() -> {
            Iterable rootPages = this.globals.getSnapshot().getAllRootPages();
            this.preBaker.start(new RootPageCrawler(this.preBaker.getWebResourceAssemblerFactory(), rootPages));
            return Response.ok((Object)new PreBakeResult(PreBakeState.RUNNING, "" + URI.create(this.info.getBaseUri() + "/prebake/bundle.zip").normalize(), this.preBaker.getBatch().getVersion(), this.preBaker.getBatch().getTaintedResources())).build();
        });
    }

    @Path(value="/state")
    @GET
    @Produces(value={"application/json"})
    public final Response get() {
        return this.whenPreBakeIsEnabled(() -> Response.ok((Object)new PreBakeResult(this.preBaker.getState(), "" + URI.create(this.info.getBaseUri() + "/prebake/bundle.zip").normalize(), this.preBaker.getBatch().getVersion(), this.preBaker.getBatch().getTaintedResources())).build());
    }

    @Path(value="/bundle.zip")
    @GET
    @Produces(value={"application/octet-stream"})
    public final Response bundle() {
        return this.whenPreBakeIsEnabled(() -> {
            PreBakeState state = this.preBaker.getState();
            if (PreBakeState.DONE == state) {
                return Response.ok((Object)new File(this.preBaker.getBundleDir(), this.preBaker.getBatch().getBundle())).header("Content-Disposition", (Object)"attachment; filename=bundle.zip").build();
            }
            log.debug("Bundle is not ready, current state is [{}]", (Object)state);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        });
    }

    private Response whenPreBakeIsEnabled(Supplier<Response> normalResponse) {
        if (this.config.isPreBakeEnabled()) {
            return normalResponse.get();
        }
        log.warn("Pre-baking called but feature is not enabled!");
        return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
    }

    public static class TaintedResourceREST {
        public final String url;
        public final String name;
        public final List<String> errors;

        public TaintedResourceREST(TaintedResource tr) {
            this.url = tr.getUrl();
            this.name = tr.getFullName();
            this.errors = Collections.unmodifiableList(tr.getPrebakeErrors().stream().map(Object::toString).collect(Collectors.toList()));
        }
    }

    public static class PreBakeResult {
        public PreBakeState state;
        public String bundle;
        public String productStateHash;
        public List<TaintedResourceREST> taintedResources;

        public PreBakeResult() {
            this.state = null;
            this.bundle = null;
            this.productStateHash = null;
            this.taintedResources = null;
        }

        public PreBakeResult(PreBakeState state, String bundle, String productStateHash, List<TaintedResource> taintedResources) {
            this.state = state;
            this.bundle = bundle;
            this.productStateHash = productStateHash;
            this.taintedResources = Collections.unmodifiableList(taintedResources.stream().map(TaintedResourceREST::new).collect(Collectors.toList()));
        }
    }
}

