/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webresource.plugin.prebake.resources;

import com.atlassian.webresource.api.UrlMode;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.api.assembler.resource.PrebakeError;
import com.atlassian.webresource.plugin.prebake.resources.Resource;
import com.google.common.base.Preconditions;
import java.util.List;
import javax.annotation.Nonnull;

public final class PluginResource
extends Resource {
    private final PluginUrlResource<?> resource;

    public PluginResource(@Nonnull PluginUrlResource<?> resource) {
        Preconditions.checkNotNull(resource);
        Preconditions.checkArgument((resource instanceof PluginJsResource || resource instanceof PluginCssResource ? 1 : 0) != 0);
        this.resource = resource;
    }

    @Override
    public String getUrl() {
        return this.resource.getStaticUrl(UrlMode.RELATIVE);
    }

    @Override
    public boolean isTainted() {
        return this.resource.isTainted();
    }

    @Override
    public List<PrebakeError> getPrebakeErrors() {
        return this.resource.getPrebakeErrors();
    }

    @Override
    public String getName() {
        return this.resource.toString();
    }

    @Override
    public String getExtension() {
        if (this.resource instanceof PluginJsResource) {
            return ".js";
        }
        if (this.resource instanceof PluginCssResource) {
            return ".css";
        }
        throw new RuntimeException("Unknown plugin resource class: '" + this.resource.getClass().getSimpleName() + "'");
    }
}

