
WRM.define("wrm/builder", function() {

    var Builder = function() {
        this.wrmKeyAttribute = "data-wrm-key";
        this.wrmBatchTypeAttribute = "data-wrm-batch-type";
    };

    Builder.prototype = {
        // Builds a list of loaded modules and contexts on the page
        initialize: function(container) {
            var scripts = container.getElementsByTagName("script"),
                links = container.getElementsByTagName("link"),
                loadedResources = {
                    modules: [],
                    contexts: []
                };

            this._inspectTagArray(scripts, loadedResources);
            this._inspectTagArray(links, loadedResources);

            return loadedResources;
        },

        _inspectTagArray: function(elements, loadedResources) {

            for (var i = 0; i < elements.length; i++) {

                var element = elements[i];

                // If the data-wrm-* attributes aren't present, continue
                if (!element.getAttribute(this.wrmKeyAttribute) || !element.getAttribute(this.wrmBatchTypeAttribute)) {
                    continue;
                }

                var keys = element.getAttribute(this.wrmKeyAttribute).split(",");
                for (var j = 0; j < keys.length; j++) {
                    var key = keys[j];
                    var batchType = element.getAttribute(this.wrmBatchTypeAttribute);

                    if (key[0] === "-") {
                        continue;
                    }

                    if (batchType === "resource") {
                        this._addToLoadedList(loadedResources.modules, key);
                    } else if (batchType === "context") {
                        this._addToLoadedList(loadedResources.contexts, key);
                    }
                }
            }
        },

        _addToLoadedList: function(loadedList, key) {
            if (loadedList.indexOf(key) !== -1) {
                return;
            }
            loadedList.push(key);
        }
    };

    return Builder;
});

