package com.atlassian.webresource.plugin.prebake.discovery;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.webresource.api.assembler.AssembledResources;
import com.atlassian.webresource.api.assembler.WebResource;
import com.atlassian.webresource.api.assembler.WebResourceSet;
import com.atlassian.webresource.api.assembler.resource.PluginCssResource;
import com.atlassian.webresource.api.assembler.resource.PluginJsResource;
import com.atlassian.webresource.api.assembler.resource.PluginUrlResource;
import com.atlassian.webresource.plugin.prebake.resources.PluginResource;
import com.atlassian.webresource.plugin.prebake.resources.Resource;

import java.util.Collection;
import java.util.Set;

/**
 * Generates a {@link Set} of resources to prebake.
 *
 * @since v3.5.0
 */
@ExperimentalApi
public interface WebResourceCrawler {

    /**
     * Generates a {@link Set} of resources to prebake.
     *
     * @return {@link Set} of resources to prebake.
     */
    Set<Resource> get();

    /**
     * Crawls the contents of an {@link AssembledResources} object and adds its content to the {@link Collection}
     * passed as a parameter.
     *
     * @param source {@link AssembledResources} object to crawl.
     * @param destination destination {@link Collection} for the resources discovered by the crawler.
     */
    default void crawlAssembledResource(AssembledResources source, Collection<Resource> destination) {
        WebResourceSet webResourceSet;
        do {
            webResourceSet = source.pollIncludedResources();
            for (WebResource resource : webResourceSet.getResources()) {
                if (!(resource instanceof PluginJsResource) && !(resource instanceof PluginCssResource)) {
                    continue;
                }
                PluginResource pr = new PluginResource((PluginUrlResource<?>) resource);
                destination.add(pr);
            }
        } while (!webResourceSet.isComplete());
    }

}
